<?php
// app/Models/SearchNotificationModel.php - YENİ

namespace App\Models;

use CodeIgniter\Model;

class SearchNotificationModel extends Model
{
    protected $table = 'search_notifications';
    protected $primaryKey = 'id';
    
    protected $useAutoIncrement = true;
    protected $returnType = 'array';
    
    protected $allowedFields = [
        'search_id',
        'property_id',
        'user_id',
        'device_id',
        'is_sent',
        'sent_at',
        'created_at'
    ];
    
    protected $useTimestamps = false;
    protected $dateFormat = 'datetime';
    protected $createdField = 'created_at';
    
    /**
     * Yeni ilan için bildirim kaydı oluştur
     */
    public function createNotification($search_id, $property_id, $user_id = null, $device_id = null)
    {
        try {
            // Daha önce oluşturulmuş mu kontrol et
            $existing = $this->where('search_id', $search_id)
                            ->where('property_id', $property_id)
                            ->first();
            
            if($existing) {
                return $existing['id']; // Zaten var
            }
            
            $data = [
                'search_id' => $search_id,
                'property_id' => $property_id,
                'user_id' => $user_id,
                'device_id' => $device_id,
                'is_sent' => 0,
                'created_at' => date('Y-m-d H:i:s')
            ];
            
            return $this->insert($data);
            
        } catch(\Exception $e) {
            log_message('error', '❌ Bildirim oluşturma hatası: ' . $e->getMessage());
            return false;
        }
    }
    
    /**
     * Gönderilmemiş bildirimleri getir
     */
    public function getPendingNotifications($limit = 100)
    {
        return $this->where('is_sent', 0)
                    ->orderBy('created_at', 'ASC')
                    ->findAll($limit);
    }
    
    /**
     * Bildirimi gönderildi olarak işaretle
     */
    public function markAsSent($notification_id)
    {
        try {
            return $this->update($notification_id, [
                'is_sent' => 1,
                'sent_at' => date('Y-m-d H:i:s')
            ]);
        } catch(\Exception $e) {
            log_message('error', '❌ Bildirim güncelleme hatası: ' . $e->getMessage());
            return false;
        }
    }
    
    /**
     * Kullanıcının bildirimlerini getir
     */
    public function getUserNotifications($user_id, $limit = 50)
    {
        $builder = $this->db->table('search_notifications sn');
        $builder->select('sn.*, sh.title as search_title, p.id as property_id');
        $builder->join('search_history sh', 'sn.search_id = sh.id', 'left');
        $builder->join('property p', 'sn.property_id = p.id', 'left');
        $builder->where('sn.user_id', $user_id);
        $builder->orderBy('sn.created_at', 'DESC');
        $builder->limit($limit);
        
        return $builder->get()->getResultArray();
    }
}