<?php

namespace App\Models;

use CodeIgniter\Model;

class FileModel extends Model
{
    protected $table      = 'file';
    protected $primaryKey = 'id';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['order', 'filename', 'filetype', 'repository_id', 'alt', 'description', 'title', 'link', 'listing_id'];

    // Custom vars

    //protected $orderBy = 'name_surname ASC';

    // Dates
    protected $useTimestamps = false;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = true;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];

    /*
    public function findAll($limit = 0, $offset = 0)
    {
        $results = parent::findAll($limit, $offset);
        
        return $results;
    }

    public function findAllListing($limit = 0, $offset = 0)
    {
        $this->select($this->table.'.*, property_user.property_id, COUNT(user_id) as count_listings');
        $this->join('property_user', $this->table.'.id = property_user.user_id', 'left');
        $this->groupBy('user_id');
        $this->orderBy('count_listings', 'DESC');

        $results = parent::findAll($limit, $offset);
        
        return $results;
    }

    public function get_pagination($limit, $offset, $where = array(), $user_check = FALSE, $user_id=NULL, $show_other_agents_litings = FALSE)
    {
        $fields_table = '';

        //$this->select('*');
        //$this->join($fields_table, $this->table.'.id = '.$fields_table.'.property_id');
        //$this->orderBy($this->table.'.id', 'DESC');

        $results = $this->findAll($limit, $offset);
        
        return $results;
    }
*/








}