<?php

namespace Config;

// Create a new instance of our RouteCollection class.
$routes = Services::routes();

/*
 * --------------------------------------------------------------------
 * Router Setup
 * --------------------------------------------------------------------
 */
$routes->setDefaultNamespace('App\Controllers');
$routes->setDefaultController('Home');
$routes->setDefaultMethod('index');
$routes->setTranslateURIDashes(false);
$routes->set404Override();

/*
 * --------------------------------------------------------------------
 * Route Definitions
 * --------------------------------------------------------------------
 */

$routes->get('/', 'Home::index');

// Get
$routes->get('/wp-json/wdk/v1/cron', 'Listings::cron');
$routes->get('/wp-json/wdk/v1/listings', 'Listings::listings');
$routes->get('/wp-json/wdk/v1/categories', 'Listings::categories');
$routes->get('/wp-json/wdk/v1/locations', 'Listings::locations');
$routes->get('/wp-json/wdk/v1/home', 'Listings::home');
$routes->get('/wp-json/wdk/v1/fields', 'Listings::fields');
$routes->get('/wp-json/wdk/v1/agents', 'Listings::agents');
$routes->get('/wp-login.php', 'Listings::redirect_login');

$routes->get('/wp-json/wdk/v1/mylistings', 'Mylistings::mylistings');
$routes->get('/wp-json/wdk/v1/move_image_top', 'Mylistings::move_image_top');

 //mülk arama için il /ilçe tümü
$routes->get('wp-json/wdk/v1/locations/all_for_search', 'Listings::getAllForSearch');


// USER MANAGEMENT ROUTES
$routes->get('/wp-json/wdk/v1/user', 'User::user');
//$routes->get('/wp-json/wdk/v1/users', 'User::users');
$routes->get('/wp-json/wdk/v1/user_statistics', 'User::user_statistics');
$routes->get('/wp-json/wdk/v1/get_consents', 'User::get_consents');
//$routes->get('/wp-json/wdk/v1/deleted_users_list', 'User::deleted_users_list');
$routes->get('/wp-json/wdk/v1/test_smtp_connection', 'User::test_smtp_connection');

// E-posta doğrulama GET routes
$routes->get('/wp-json/wdk/v1/verify_email', 'User::verify_email');
$routes->get('/verify-email', 'User::verify_email');
$routes->get('/wp-json/wdk/v1/test_email', 'User::test_email');

// Hiyerarşik lokasyon endpoint'leri
$routes->get('/wp-json/wdk/v1/provinces', 'Listings::provinces');
$routes->get('/wp-json/wdk/v1/districts', 'Listings::districts');
$routes->get('/wp-json/wdk/v1/neighborhoods', 'Listings::neighborhoods');
$routes->get('/wp-json/wdk/v1/locations_hierarchy', 'Listings::locations_hierarchy');

// USER MANAGEMENT POST ROUTES
$routes->post('/wp-json/wdk/v1/login', 'User::login');
$routes->post('/wp-json/wdk/v1/edit_user', 'User::edit_user');
$routes->post('/wp-json/wdk/v1/register', 'User::register');
$routes->post('/wp-json/wdk/v1/registerDevice', 'User::registerDevice');
$routes->post('/wp-json/wdk/v1/auth_register', 'User::auth_register');
$routes->post('/wp-json/wdk/v1/refresh_token', 'User::refresh_token');

// E-posta doğrulama POST routes
$routes->post('/wp-json/wdk/v1/send_verification_email', 'User::send_verification_email');
$routes->post('/wp-json/wdk/v1/verify_email_code', 'User::verify_email_code');
$routes->post('/wp-json/wdk/v1/resend_verification', 'User::send_verification_email');

// Şifre sıfırlama routes
$routes->post('/wp-json/wdk/v1/send_password_reset_code', 'User::send_password_reset_code');
$routes->post('/wp-json/wdk/v1/verify_password_reset_code', 'User::verify_password_reset_code');
$routes->post('/wp-json/wdk/v1/reset_password_with_code', 'User::reset_password_with_code');

// Alternatif short routes
$routes->post('/wp-json/wdk/v1/forgot_password', 'User::send_password_reset_code');
$routes->post('/wp-json/wdk/v1/reset_password', 'User::reset_password_with_code');

// User Type Management Routes (Admin only)
//$routes->post('/wp-json/wdk/v1/change_user_type', 'User::change_user_type');

// İzin ve cihaz yönetimi routes
$routes->post('/wp-json/wdk/v1/transfer_consents', 'User::transfer_consents');
$routes->post('/wp-json/wdk/v1/update_push_token', 'User::update_push_token');
$routes->post('/wp-json/wdk/v1/update_topic_subscriptions', 'User::update_topic_subscriptions');
$routes->post('/wp-json/wdk/v1/update_device_status', 'User::update_device_status');

// Hesap silme
$routes->delete('/wp-json/wdk/v1/delete_user', 'User::delete');

// ENQUIRY ROUTES - ENQUIREController'a yönlendirildi
// Ana enquiry mesaj endpoint'i
$routes->post('/wp-json/wdk/v1/listing_agent_message', 'EnquireController::listing_agent_message');


$routes->get('/wp-json/wdk/v1/getMyEnquiries', 'EnquireController::getMyEnquiries');
$routes->post('/wp-json/wdk/v1/markEnquiryAsRead', 'EnquireController::markEnquiryAsRead'); // ✅ markAsRead değil markEnquiryAsRead
$routes->post('/wp-json/wdk/v1/sendUserReply', 'EnquireController::sendUserReply');
// Enquiry API rotaları - DÜZELTİLDİ
$routes->group('wp-json/enquire', function($routes) {
    // GET endpoints
    $routes->get('getEnquiries', 'EnquireController::getEnquiries');
    $routes->get('getEnquiryDetails', 'EnquireController::getEnquiryDetails');
    $routes->get('unread_count', 'EnquireController::getUnreadCount');
    $routes->get('upcoming_appointments', 'EnquireController::getUpcomingAppointments');
    
 
    
    // Admin-only GET endpoints
    $routes->get('getCustomerEnquiries', 'EnquireController::getCustomerEnquiries');
    $routes->get('getPropertyEnquiries', 'EnquireController::getPropertyEnquiries');
    
    // Agent-only GET endpoints
    $routes->get('getAgentNotificationInfo', 'EnquireController::getAgentNotificationInfo');
    
    // POST endpoints
    $routes->post('reply', 'EnquireController::addReply');
    $routes->post('close', 'EnquireController::closeEnquiry');
    $routes->post('send_call_reminder', 'EnquireController::sendCallReminder');
    
     // ✅ YENİ: Admin → Müşteri bildirim endpoint'i (CRM kullanır)
    $routes->post('sendCustomerReplyNotification', 'EnquireController::sendCustomerReplyNotification');
    
    
    // Admin-only POST endpoints
    $routes->post('addAdminNote', 'EnquireController::addAdminNote');
});

// Listings POST routes
$routes->post('/wp-json/wdk/v1/listing_favorite', 'Listings::listing_favorite');
$routes->post('/wp-json/wdk/v1/hidden_listings', 'Listings::listing_hidden');
$routes->post('/wp-json/wdk/v1/listing_hidden', 'Listings::listing_hidden');

// Property Search Request endpoint
$routes->post('/wp-json/wdk/v1/property_search_request', 'SearchRequestController::propertySearchRequest');

// My Listings routes
$routes->post('/wp-json/wdk/v1/edit_listing', 'Mylistings::edit_listing');
$routes->post('/wp-json/wdk/v1/images_upload', 'Mylistings::images_upload');
$routes->delete('/wp-json/wdk/v1/delete_listing', 'Mylistings::delete');
$routes->delete('/wp-json/wdk/v1/delete_image', 'Mylistings::delete_image');

// Property Search Request API rotaları
$routes->group('wp-json/search_request', function($routes) {
    $routes->get('list', 'SearchRequestController::getSearchRequests');
    $routes->get('detail', 'SearchRequestController::getRequestDetails');
    $routes->post('assign', 'SearchRequestController::assignToAgent');
    $routes->post('reply', 'SearchRequestController::addReply');
    $routes->post('complete', 'SearchRequestController::completeRequest');
    $routes->get('my_requests', 'SearchRequestController::getMyRequests');
    $routes->post('update_criteria', 'SearchRequestController::updateCriteria');
    $routes->get('unread_count', 'SearchRequestController::getUnreadCount');
    $routes->post('bulk_update_status', 'SearchRequestController::bulkUpdateStatus');
    $routes->get('categories_count', 'SearchRequestController::getCategoriesCount');
    $routes->get('stats', 'SearchRequestController::getStats');
    $routes->get('export', 'SearchRequestController::exportRequests');
});

// KVKK, GDPR ve İzin yönetimi API rotaları
$routes->group('wp-json/consent', function($routes) {
    $routes->get('test', 'ConsentController::test');
    $routes->get('getConsents', 'ConsentController::getConsents');
    $routes->post('saveConsents', 'ConsentController::saveConsents');
    $routes->get('getConsentHistory', 'ConsentController::getConsentHistory');
    $routes->post('updateSingleConsent', 'ConsentController::updateSingleConsent');
    $routes->post('checkConsentVersions', 'ConsentController::checkConsentVersions');
    $routes->post('exportUserData', 'ConsentController::exportUserData');
    $routes->post('transferConsents', 'ConsentController::transferConsents');
    $routes->post('update_push_token', 'ConsentController::update_push_token');
    $routes->post('update_topic_subscriptions', 'ConsentController::update_topic_subscriptions');
    $routes->post('update_device_status', 'ConsentController::update_device_status');
    $routes->post('updateConsents', 'ConsentController::updateSingleConsent');
});

// GDPR Veri İşleme API rotaları
$routes->group('wp-json/gdpr', function($routes) {
    $routes->post('forgetMe', 'ForgetMeController::forgetMe');
    $routes->post('export_request', 'GdprController::requestDataExport');
    $routes->get('export_status', 'GdprController::getExportStatus');
    $routes->get('download_export', 'GdprController::downloadExport');
    $routes->post('deletion_request', 'GdprController::requestDataDeletion');
    $routes->get('deletion_status', 'GdprController::getDeletionStatus');
});

// Bildirim yönetimi API rotaları
$routes->group('wp-json/notification', function($routes) {
    $routes->get('settings', 'NotificationController::getSettings');
    $routes->post('settings', 'NotificationController::updateSettings');
    $routes->get('list', 'NotificationController::getUserNotifications');
    $routes->post('mark_read', 'NotificationController::mark_read');
    $routes->post('mark_delivered', 'NotificationController::mark_delivered');
    $routes->delete('delete', 'NotificationController::deleteNotification');
    $routes->get('unread_count', 'NotificationController::getUnreadCount');
    $routes->post('send', 'NotificationController::send');
    $routes->post('update_token', 'NotificationController::update_token');
    $routes->post('update_device_status', 'NotificationController::update_device_status');
});

// Cihaz yönetimi API rotaları
$routes->group('wp-json/device', function($routes) {
    $routes->post('register_device', 'DeviceController::register_device');
    $routes->post('update_device_info', 'DeviceController::update_device_info');
    $routes->post('update_push_token', 'DeviceController::update_push_token');
    $routes->post('update_topic_subscriptions', 'DeviceController::update_topic_subscriptions');
    $routes->post('update_device_status', 'DeviceController::update_device_status');
    $routes->get('get_user_devices', 'DeviceController::get_user_devices');
    $routes->post('remove_device', 'DeviceController::remove_device');
});

// API Logları Yönetim Paneli Rotaları
$routes->group('admin/api-logs', ['namespace' => 'App\Controllers\Admin'], function($routes) {
    $routes->get('/', 'ApiLogs::index');
    $routes->get('get-logs', 'ApiLogs::getLogs');
    $routes->get('view/(:num)', 'ApiLogs::view/$1');
    $routes->get('delete/(:num)', 'ApiLogs::delete/$1');
    $routes->post('purge', 'ApiLogs::purge');
    $routes->get('export', 'ApiLogs::export');
});

// Yönetim paneli rotaları
$routes->group('admin', ['namespace' => 'App\Controllers\Admin'], function($routes) {
    // İzin yönetimi
    $routes->group('consents', function($routes) {
        $routes->get('/', 'ConsentsAdmin::index');
        $routes->get('history/(:num)', 'ConsentsAdmin::history/$1');
        $routes->get('versions', 'ConsentsAdmin::versions');
        $routes->post('versions', 'ConsentsAdmin::updateVersions');
    });
    
    // Bildirim yönetimi
    $routes->group('notifications', function($routes) {
        $routes->get('/', 'NotificationsAdmin::index');
        $routes->get('new', 'NotificationsAdmin::new');
        $routes->post('send', 'NotificationsAdmin::send');
        $routes->get('stats', 'NotificationsAdmin::stats');
    });
    
    // User yönetimi
    $routes->group('users', function($routes) {
        $routes->get('/', 'UsersAdmin::index');
        $routes->get('view/(:num)', 'UsersAdmin::view/$1');
        $routes->get('stats', 'UsersAdmin::stats');
        $routes->post('change_type', 'UsersAdmin::changeUserType');
        $routes->post('bulk_action', 'UsersAdmin::bulkAction');
        $routes->get('export', 'UsersAdmin::export');
        $routes->get('deleted', 'UsersAdmin::deleted');
        $routes->post('restore/(:num)', 'UsersAdmin::restore/$1');
    });
    
    // Cihaz yönetimi
    $routes->group('devices', function($routes) {
        $routes->get('/', 'DevicesAdmin::index');
        $routes->get('view/(:segment)', 'DevicesAdmin::view/$1');
        $routes->post('status', 'DevicesAdmin::updateStatus');
        $routes->get('stats', 'DevicesAdmin::stats');
    });
    
    // GDPR veri işleme talepleri
    $routes->group('gdpr', function($routes) {
        $routes->get('exports', 'GdprAdmin::exports');
        $routes->get('deletions', 'GdprAdmin::deletions');
        $routes->post('process_export/(:num)', 'GdprAdmin::processExport/$1');
        $routes->post('process_deletion/(:num)', 'GdprAdmin::processDeletion/$1');
    });
    
    // Enquiry yönetimi
    $routes->group('enquiries', function($routes) {
        $routes->get('/', 'EnquiriesAdmin::index');
        $routes->get('view/(:num)', 'EnquiriesAdmin::view/$1');
        $routes->get('stats', 'EnquiriesAdmin::stats');
        $routes->post('bulk_action', 'EnquiriesAdmin::bulkAction');
    });
    
    // Property Search Request Admin yönetimi
    $routes->group('search_requests', function($routes) {
        $routes->get('/', 'SearchRequestsAdmin::index');
        $routes->get('view/(:num)', 'SearchRequestsAdmin::view/$1');
        $routes->get('stats', 'SearchRequestsAdmin::stats');
        $routes->post('bulk_action', 'SearchRequestsAdmin::bulkAction');
        $routes->get('export', 'SearchRequestsAdmin::export');
        $routes->get('dashboard', 'SearchRequestsAdmin::dashboard');
        $routes->get('agent_performance', 'SearchRequestsAdmin::agentPerformance');
        $routes->get('criteria_analysis', 'SearchRequestsAdmin::criteriaAnalysis');
        $routes->get('assignment_rules', 'SearchRequestsAdmin::assignmentRules');
        $routes->post('assignment_rules', 'SearchRequestsAdmin::updateAssignmentRules');
        $routes->get('reply_templates', 'SearchRequestsAdmin::replyTemplates');
        $routes->post('reply_templates', 'SearchRequestsAdmin::saveReplyTemplate');
        $routes->delete('reply_templates/(:num)', 'SearchRequestsAdmin::deleteReplyTemplate/$1');
        $routes->get('notification_settings', 'SearchRequestsAdmin::notificationSettings');
        $routes->post('notification_settings', 'SearchRequestsAdmin::updateNotificationSettings');
    });
});

// Agent Dashboard rotaları
$routes->group('agent', ['namespace' => 'App\Controllers\Agent'], function($routes) {
    $routes->get('dashboard', 'Dashboard::index');
    
    $routes->group('search_requests', function($routes) {
        $routes->get('/', 'SearchRequests::index');
        $routes->get('view/(:num)', 'SearchRequests::view/$1');
        $routes->post('reply/(:num)', 'SearchRequests::addReply/$1');
        $routes->post('complete/(:num)', 'SearchRequests::complete/$1');
        $routes->post('update_criteria/(:num)', 'SearchRequests::updateCriteria/$1');
        $routes->get('stats', 'SearchRequests::getStats');
    });
    
    $routes->group('enquiries', function($routes) {
        $routes->get('/', 'Enquiries::index');
        $routes->get('view/(:num)', 'Enquiries::view/$1');
        $routes->post('reply/(:num)', 'Enquiries::addReply/$1');
        $routes->post('close/(:num)', 'Enquiries::close/$1');
        $routes->post('call_reminder/(:num)', 'Enquiries::sendCallReminder/$1');
        $routes->get('upcoming_appointments', 'Enquiries::upcomingAppointments');
    });
    
    $routes->get('profile', 'Profile::index');
    $routes->post('profile', 'Profile::update');
    $routes->get('notifications', 'Profile::notificationSettings');
    $routes->post('notifications', 'Profile::updateNotificationSettings');
});

// İstatistik ve Raporlama API rotaları
$routes->group('wp-json/stats', function($routes) {
    $routes->get('enquiries', 'StatsController::enquiryStats');
    $routes->get('enquiries/agent/(:num)', 'StatsController::agentEnquiryStats/$1');
    $routes->get('search_requests', 'StatsController::searchRequestStats');
    $routes->get('search_requests/agent/(:num)', 'StatsController::agentSearchRequestStats/$1');
    $routes->get('dashboard', 'StatsController::dashboardStats');
    $routes->get('performance/agents', 'StatsController::agentPerformance');
    $routes->get('performance/overview', 'StatsController::performanceOverview');
    $routes->get('trends/enquiries', 'StatsController::enquiryTrends');
    $routes->get('trends/search_requests', 'StatsController::searchRequestTrends');
    $routes->get('popular_criteria', 'StatsController::popularSearchCriteria');
    $routes->get('conversion_rates', 'StatsController::conversionRates');
});

// Webhook rotaları
$routes->group('webhooks', function($routes) {
    $routes->post('fcm_delivery', 'WebhookController::fcmDeliveryStatus');
    $routes->post('email_delivery', 'WebhookController::emailDeliveryStatus');
    $routes->post('crm_sync', 'WebhookController::crmSync');
    $routes->post('property_updates', 'WebhookController::propertyUpdates');
});

// Cron job rotaları
$routes->group('cron', function($routes) {
    $routes->get('appointment_reminders', 'CronController::sendAppointmentReminders');
    $routes->get('search_request_followups', 'CronController::searchRequestFollowUps');
    $routes->get('cleanup_old_data', 'CronController::cleanupOldData');
    $routes->get('daily_reports', 'CronController::generateDailyReports');
    $routes->get('update_property_indexes', 'CronController::updatePropertyIndexes');
    $routes->get('sync_external_data', 'CronController::syncExternalData');
});

// Mobile app specific routes
$routes->group('mobile', function($routes) {
    $routes->get('config', 'MobileController::getAppConfig');
    $routes->get('features', 'MobileController::getFeatureFlags');
    $routes->get('version_check', 'MobileController::checkVersion');
    $routes->post('emergency_notification', 'MobileController::sendEmergencyNotification');
    $routes->post('feedback', 'MobileController::submitFeedback');
    $routes->post('crash_report', 'MobileController::submitCrashReport');
});

// Analytics API endpoints
$routes->post('/wp-json/wdk/v1/analytics/record_view', 'AnalyticsController::recordView');
$routes->post('/wp-json/wdk/v1/analytics/update_view_duration', 'AnalyticsController::updateViewDuration');
$routes->post('/wp-json/wdk/v1/analytics/record_search', 'AnalyticsController::recordSearch');
$routes->post('/wp-json/wdk/v1/analytics/record_app_open', 'AnalyticsController::recordAppOpen');

$routes->get('/wp-json/wdk/v1/analytics/property_stats', 'AnalyticsController::getPropertyStats');
$routes->get('/wp-json/wdk/v1/analytics/agent_portfolio_stats', 'AnalyticsController::getAgentPortfolioStats');
$routes->get('/wp-json/wdk/v1/analytics/user_stats', 'AnalyticsController::getUserStats');
$routes->get('/wp-json/wdk/v1/analytics/admin_dashboard', 'AnalyticsController::getAdminDashboard');


 $routes->get('/wp-json/wdk/v1/analytics/search_statistics', 'AnalyticsController::getSearchStatistics');
 $routes->get('/wp-json/wdk/v1/analytics/user_search_history', 'AnalyticsController::getUserSearchHistory');
 // ✅ YENİ: Kayıtlı Arama Yönetimi
    $routes->get('/wp-json/wdk/v1/analytics/user_searches', 'AnalyticsController::getUserSearches');
    $routes->post('/wp-json/wdk/v1/analytics/save_search', 'AnalyticsController::saveSearch');
    $routes->post('/wp-json/wdk/v1/analytics/delete_search', 'AnalyticsController::deleteSearch');
    $routes->post('/wp-json/wdk/v1/analytics/toggle_search_notification', 'AnalyticsController::toggleSearchNotification');   



/*
 * --------------------------------------------------------------------
 * Additional Routing
 * --------------------------------------------------------------------
 */
if (is_file(APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php')) {
    require APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php';
}