<?php

namespace Config;

use CodeIgniter\Config\BaseConfig;

/**
 * Firebase yapılandırma
 * 
 * Bu dosya, Firebase Cloud Messaging (FCM) ve diğer Firebase hizmetleri için
 * gerekli yapılandırma ayarlarını içerir.
 */
class Firebase extends BaseConfig
{
    /**
     * Firebase Server Key
     * 
     * Firebase Console -> Project Settings -> Cloud Messaging -> Server key
     * 
     * @var string
     */
    public $serverKey = 'AIzaSyCxTR9dlPYDz03JNnrHsFbjPM0XeYLkk6k';
    
    /**
     * Firebase Project ID
     * 
     * @var string
     */
    public $projectId = 'satisahazirv1';
    
    /**
     * Firebase API URL
     * 
     * @var string
     */
    public $fcmUrl = 'https://fcm.googleapis.com/fcm/send';
    
    /**
     * Bildirim varsayılan seçenekleri
     * 
     * @var array
     */
    public $defaultOptions = [
        'sound' => 'default',
        'icon' => 'notification_icon',
        'color' => '#112D4F', // Uygulama ana rengi
        'android_channel_id' => 'satisahazir_notifications',
    ];
    
    /**
     * Android bildirim kanal ID'si
     * 
     * @var string
     */
    public $androidChannelId = 'satisahazir_notifications';
    
    /**
     * Varsayılan bildirim konuları 
     * 
     * @var array
     */
    public $topics = [
        'anonymous', // Anonim kullanıcılar için
        'marketing', // Pazarlama bildirimleri
        'emergency', // Acil bildirimler
        'news'       // Haberler ve güncellemeler
    ];
}