<?php

namespace Config;

use CodeIgniter\Config\Filters as BaseFilters;
use CodeIgniter\Filters\Cors;
use CodeIgniter\Filters\CSRF;
use CodeIgniter\Filters\DebugToolbar;
use CodeIgniter\Filters\ForceHTTPS;
use CodeIgniter\Filters\Honeypot;
use CodeIgniter\Filters\InvalidChars;
use CodeIgniter\Filters\PageCache;
use CodeIgniter\Filters\PerformanceMetrics;
use CodeIgniter\Filters\SecureHeaders;

// Sizin özel filtreleriniz
use App\Filters\ApiLogger;
use App\Filters\ErrorLogger;

class Filters extends BaseFilters
{
    /**
     * Configures aliases for Filter classes to
     * make reading things nicer and simpler.
     *
     * @var array<string, class-string|list<class-string>>
     */
    public array $aliases = [
        // CI 4.6 varsayılan filtreleri
        'csrf'          => CSRF::class,
        'toolbar'       => DebugToolbar::class,
        'honeypot'      => Honeypot::class,
        'invalidchars'  => InvalidChars::class,
        'secureheaders' => SecureHeaders::class,
        'cors'          => Cors::class,
        'forcehttps'    => ForceHTTPS::class,
        'pagecache'     => PageCache::class,
        'performance'   => PerformanceMetrics::class,
        
        // Sizin özel filtreleriniz
        'apilogger'     => ApiLogger::class,
        'errorlogger'   => ErrorLogger::class,
    ];

    /**
     * List of special required filters.
     * 
     * CI 4.6'da YENİ - Framework tarafından zorunlu filtreler
     * Bu filtreler her zaman çalışır, route olmasa bile.
     *
     * @var array{before: list<string>, after: list<string>}
     */
    public array $required = [
        'before' => [
            'forcehttps', // Force Global Secure Requests
            'pagecache',  // Web Page Caching
        ],
        'after' => [
            'pagecache',   // Web Page Caching
            'performance', // Performance Metrics
            'toolbar',     // Debug Toolbar
        ],
    ];

    /**
     * List of filter aliases that are always
     * applied before and after every request.
     *
     * @var array{before: list<string>, after: list<string>}
     */
    public array $globals = [
        'before' => [
            // 'honeypot',
            // 'csrf',
            // 'invalidchars',
            'errorlogger', // Tüm istekler için hata yakalayıcıyı etkinleştir
        ],
        'after' => [
            // 'honeypot',
            // 'secureheaders',
            'apilogger', // Mevcut API loglayıcı
        ],
    ];

    /**
     * List of filter aliases that works on a
     * particular HTTP method (GET, POST, etc.).
     *
     * @var array<string, list<string>>
     */
    public array $methods = [];

    /**
     * List of filter aliases that should run on any
     * before or after URI patterns.
     *
     * @var array<string, array<string, list<string>>>
     */
    public array $filters = [
        'apilogger' => [
            'after' => ['wp-json/*'], // Sadece API rotaları için loglama
        ],
        'errorlogger' => [
            'before' => ['wp-json/*'], // API rotaları için hata yakalama
        ],
    ];
}