<?php

namespace Config;

use CodeIgniter\Database\Config;

/**
 * Database Configuration
 */
class Database extends Config
{
    /**
     * The directory that holds the Migrations and Seeds directories.
     */
    public string $filesPath = APPPATH . 'Database' . DIRECTORY_SEPARATOR;

    /**
     * Lets you choose which connection group to use if no other is specified.
     */
    public string $defaultGroup = 'default';

    /**
     * Ana database connection.
     *
     * @var array<string, mixed>
     */
    public array $default = [
        'DSN'          => '',
        'hostname'     => 'localhost',
        'username'     => 'pgfsatis_users',
        'password'     => 'l@g+i;je~yP4',  // .env dosyasından alınacak
        'database'     => 'pgfsatis_2026',
        'DBDriver'     => 'MySQLi',
        'DBPrefix'     => '',
        'pConnect'     => false,
        'DBDebug'      => true,  // Production'da false yapın
        'charset'      => 'utf8mb4',  // 4.6 - Emoji desteği için
        'DBCollat'     => 'utf8mb4_general_ci',  // 4.6 - Güncel collation
        'swapPre'      => '',
        'encrypt'      => false,
        'compress'     => false,
        'strictOn'     => false,
        'failover'     => [],
        'port'         => 3306,
        'numberNative' => false,  // 4.6 YENİ
        'foundRows'    => false,  // 4.6 YENİ
        'dateFormat'   => [       // 4.6 YENİ
            'date'     => 'Y-m-d',
            'datetime' => 'Y-m-d H:i:s',
            'time'     => 'H:i:s',
        ],
    ];

    /**
     * API Logs için ayrı veritabanı
     *
     * @var array<string, mixed>
     */
    public array $api_logs = [
        'DSN'          => '',
        'hostname'     => 'localhost',
        'username'     => 'pgfsatis_users',
        'password'     => 'l@g+i;je~yP4',
    //    'username'     => 'pgfsatis_log_user',
    //    'password'     => '_Ef^Ol(,1O1{',  // .env dosyasından alınacak
        'database'     => 'pgfsatis_api_logs',
        'DBDriver'     => 'MySQLi',
        'DBPrefix'     => '',
        'pConnect'     => false,
        'DBDebug'      => true,  // Production'da false yapın
        'charset'      => 'utf8mb4',  // 4.6 - Güncel charset
        'DBCollat'     => 'utf8mb4_general_ci',  // 4.6 - Güncel collation
        'swapPre'      => '',
        'encrypt'      => false,
        'compress'     => false,
        'strictOn'     => false,
        'failover'     => [],
        'port'         => 3306,
        'numberNative' => false,  // 4.6 YENİ
        'foundRows'    => false,  // 4.6 YENİ
        'dateFormat'   => [       // 4.6 YENİ
            'date'     => 'Y-m-d',
            'datetime' => 'Y-m-d H:i:s',
            'time'     => 'H:i:s',
        ],
    ];
    
        /**
     * API Logs için ayrı veritabanı
     *
     * @var array<string, mixed>
     */
    public array $logs = [
        'DSN'          => '',
        'hostname'     => 'localhost',
        'username'     => 'pgfsatis_log_user',
        'password'     => '_Ef^Ol(,1O1{',  // .env dosyasından alınacak
        'database'     => 'pgfsatis_logs',
        'DBDriver'     => 'MySQLi',
        'DBPrefix'     => '',
        'pConnect'     => false,
        'DBDebug'      => true,  // Production'da false yapın
        'charset'      => 'utf8mb4',  // 4.6 - Güncel charset
        'DBCollat'     => 'utf8mb4_general_ci',  // 4.6 - Güncel collation
        'swapPre'      => '',
        'encrypt'      => false,
        'compress'     => false,
        'strictOn'     => false,
        'failover'     => [],
        'port'         => 3306,
        'numberNative' => false,  // 4.6 YENİ
        'foundRows'    => false,  // 4.6 YENİ
        'dateFormat'   => [       // 4.6 YENİ
            'date'     => 'Y-m-d',
            'datetime' => 'Y-m-d H:i:s',
            'time'     => 'H:i:s',
        ],
    ];


    /**
     * This database connection is used when running PHPUnit database tests.
     *
     * @var array<string, mixed>
     */
    public array $tests = [
        'DSN'          => '',
        'hostname'     => '127.0.0.1',
        'username'     => '',
        'password'     => '',
        'database'     => ':memory:',
        'DBDriver'     => 'SQLite3',
        'DBPrefix'     => 'db_',
        'pConnect'     => false,
        'DBDebug'      => true,
        'charset'      => 'utf8',
        'DBCollat'     => '',
        'swapPre'      => '',
        'encrypt'      => false,
        'compress'     => false,
        'strictOn'     => false,
        'failover'     => [],
        'port'         => 3306,
        'foreignKeys'  => true,
        'busyTimeout'  => 1000,
        'synchronous'  => null,
        'dateFormat'   => [
            'date'     => 'Y-m-d',
            'datetime' => 'Y-m-d H:i:s',
            'time'     => 'H:i:s',
        ],
    ];

    public function __construct()
    {
        parent::__construct();

        // Ensure that we always set the database group to 'tests' if
        // we are currently running an automated test suite, so that
        // we don't overwrite live data on accident.
        if (ENVIRONMENT === 'testing') {
            $this->defaultGroup = 'tests';
        }
    }
}

