<?php

namespace App\Models;

use CodeIgniter\Model;

class SetingsModel extends Model
{
    protected $table      = 'settings';
    protected $primaryKey = 'id';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = [];

    // Custom vars

    protected $orderBy = 'order ASC';

    // Dates
    protected $useTimestamps = false;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = true;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];

    public function get_setting($field)
    {
        static $all_settings = array();

        if(count($all_settings) == 0)
        {
            $results = parent::findAll();

            foreach($results as $setting)
            {
                $all_settings[$setting['field']] = $setting['value'];
            }
        }

        if(!isset($all_settings[$field]))
            return NULL;
        
        return $all_settings[$field];
    }

}