<?php

namespace App\Controllers;
use CodeIgniter\RESTful\ResourceController;
use CodeIgniter\API\ResponseTrait;

class User extends BaseController
{
    use ResponseTrait;

    /**
     * Kullanıcı Girişi - DÜZELTME: Device bilgilerini doğru şekilde kaydet
     */
       public function login()
    {
        $data = array(
            'code'      => 'empty_code',
            'message'   => 'Empty Message'
        );

        $data_json = $this->request->getJSON();

        $listingModel = model('App\Models\ListingModel');
        $userModel = model('App\Models\UserModel');
        $favoriteModel = model('App\Models\FavoriteModel');
        $tokenModel = model('App\Models\TokenModel');
        $deviceModel = model('App\Models\DeviceModel');

        $validation = \Config\Services::validation();

        $validation->setRules([
            'email' => ['label' => 'Email', 'rules' => 'required'],
            'password' => ['label' => 'Password', 'rules' => 'required'],
        ]);

        if ($validation->withRequest($this->request)->run()) {
            $results = $userModel->where('mail', $data_json->email)
                                 ->where('mail_verified', 1)
                                 ->where('password', $userModel->hash($data_json->password))
                                 ->findAll(1); 

            if(count($results) == 0)
            {
                $result_not_activated = $userModel->where('mail', $data_json->email)
                                                  ->where('password', $userModel->hash($data_json->password))
                                                  ->findAll(1); 
                
                if(count($result_not_activated) > 0) {
                    $user_data = $result_not_activated[0];
                    
                    if($data_json->returnSecureToken)
                    {
                        $tokenModel->where('date_last_access < \''.date('Y-m-d H:i:s', strtotime("-2 months")).'\'', NULL)
                                   ->delete();                    
        
                        $ip = '';
                        if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
                            $ip = $_SERVER['HTTP_CLIENT_IP'];
                        } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
                            $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
                        } else {
                            $ip = $_SERVER['REMOTE_ADDR'];
                        }

                        $token = $userModel->hash_token($data_json->email.$data_json->password.time().rand(1,9999));
        
                        $tokenData = array();
                        $tokenData['date_last_access'] = date('Y-m-d H:i:s');
                        $tokenData['ip'] = $ip;
                        $tokenData['username'] = $user_data['username'];
                        $tokenData['user_id'] = $user_data['id'];
                        $tokenData['display_name'] = $user_data['name_surname'];
                        $tokenData['token'] = $token;
                        $tokenData['other'] = '';
                
                        $insert_idtoken = $tokenModel->insert($tokenData);
                        
                        // ✅ DÜZELTME: E-posta login için login_method = 'email'
                        if(!empty($data_json->device_uuid)) {
                            $this->saveDeviceInfo($user_data['id'], $user_data['mail'], $data_json, 'email');
                        }
                        
                        return $this->respond(array(
                            'localId'       => $user_data['id'],
                            'display_name'  => $user_data['name_surname'],
                            'user_email'    => $user_data['mail'],
                            'code'          => 'email_verification_required',
                            'message'       => 'Lütfen Kurumsal E-postanıza gelen Aktivasyon kodunu girin.',
                            'token'         => $token,
                            'expire_date'   => strtotime("+2 months"),
                            'verified'      => '0',
                            'mail_verified' => '0',
                            'email_verification_required' => true,
                            'type'          => $user_data['type'] ?? 'USER'
                        ));
                    } else {
                        return $this->respond(array(
                            'code'          => 'failed',
                            'message'       => 'Lütfen Kurumsal E-postanıza gelen Aktivasyon linkine tıklayınız.',
                            'verified'      => '0',
                            'mail_verified' => '0',
                            'type'          => $user_data['type'] ?? 'USER'
                        ));
                    }
                }                                
            }

            if(count($results) > 0)
            {
                $user_data = $results[0];

                if($data_json->returnSecureToken)
                {
                    $tokenModel->where('date_last_access < \''.date('Y-m-d H:i:s', strtotime("-2 months")).'\'', NULL)
                               ->delete();                    

                    $ip = '';
                    if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
                        $ip = $_SERVER['HTTP_CLIENT_IP'];
                    } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
                        $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
                    } else {
                        $ip = $_SERVER['REMOTE_ADDR'];
                    }

                    $token = $userModel->hash_token($data_json->email.$data_json->password.time().rand(1,9999));

                    $data = array();
                    $data['date_last_access'] = date('Y-m-d H:i:s');
                    $data['ip'] = $ip;
                    $data['username'] = $user_data['username'];
                    $data['user_id'] = $user_data['id'];
                    $data['display_name'] = $user_data['name_surname'];
                    $data['token'] = $token;
                    $data['other'] = '';
            
                    $insert_idtoken = $tokenModel->insert($data);
                    
                    // ✅ DÜZELTME: E-posta login için login_method = 'email'
                    if(!empty($data_json->device_uuid)) {
                        $this->saveDeviceInfo($user_data['id'], $user_data['mail'], $data_json, 'email');
                    }
               
                    return $this->respond(array(
                        'localId'       => $user_data['id'],
                        'display_name'  => $user_data['name_surname'],
                        'user_email'    => $user_data['mail'],
                        'code'          => 'success',
                        'message'       => 'Başarıyla giriş yapıldı.',
                        'token'         => $token,
                        'expire_date'   => strtotime("+2 months"),
                        'verified'      => $user_data['mail_verified'],
                        'mail_verified' => $user_data['mail_verified'],
                        'type'          => $user_data['type'] ?? 'USER'
                    ));
                }

                return $this->respond(array(
                    'code'      => 'success',
                    'message'   => 'Başarıyla giriş yapıldı.',
                    'type'      => $user_data['type'] ?? 'USER'
                ));
            }

            return $this->respond(array(
                'code'      => 'failed',
                'message'   => 'Kurumsal E-posta veya Şifreniz yanlış.'
            ));
        }

        return $this->respond(array(
            'code'      => 'failed',
            'message'   => join("\n", $validation->getErrors())
        ));
    }

    /**
     * YENİ: Cihaz bilgilerini kaydet helper metodu
     */
   private function saveDeviceInfo($userId, $userEmail, $requestData, $loginMethod = 'unknown')
    {
        try {
            $deviceModel = model('App\Models\DeviceModel');
            
            // Cihaz verileri hazırla
            $deviceData = [
                'user_id' => $userId,
                'email' => $userEmail,
                'device_uuid' => $requestData->device_uuid ?? '',
                'fcmToken' => $requestData->fcmToken ?? '',
                'push_token' => $requestData->fcmToken ?? '',
                'is_active' => 1,
                'last_active' => date('Y-m-d H:i:s'),
                'login_method' => $loginMethod // ✅ YENİ: login_method eklendi
            ];
            
            // Platform bilgileri ekle
            if (!empty($requestData->platform)) {
                $deviceData['platform'] = $requestData->platform;
            }
            
            if (!empty($requestData->device_name)) {
                $deviceData['device_name'] = $requestData->device_name;
            }
            
            if (!empty($requestData->system_name)) {
                $deviceData['system_name'] = $requestData->system_name;
            }
            
            if (!empty($requestData->system_version)) {
                $deviceData['system_version'] = $requestData->system_version;
            }
            
            if (!empty($requestData->device_model)) {
                $deviceData['device_model'] = $requestData->device_model;
            }
            
            if (!empty($requestData->brand)) {
                $deviceData['brand'] = $requestData->brand;
            }
            
            if (!empty($requestData->device_brand)) {
                $deviceData['device_brand'] = $requestData->device_brand;
            }
            
            if (!empty($requestData->manufacturer)) {
                $deviceData['manufacturer'] = $requestData->manufacturer;
            }
            
            if (!empty($requestData->android_version)) {
                $deviceData['android_version'] = $requestData->android_version;
            }
            
            if (!empty($requestData->app_version)) {
                $deviceData['app_version'] = $requestData->app_version;
            }
            
            if (!empty($requestData->app_build_number)) {
                $deviceData['app_build_number'] = $requestData->app_build_number;
            }
            
            // Dil ve ülke bilgisi
            if (!empty($requestData->language)) {
                $deviceData['language'] = $requestData->language;
            }
            
            if (!empty($requestData->country_code)) {
                $deviceData['country_code'] = $requestData->country_code;
            }
            
            if (!empty($requestData->country)) {
                $deviceData['country'] = $requestData->country;
            }
            
            if (!empty($requestData->region)) {
                $deviceData['region'] = $requestData->region;
            }
            
            // İzin durumları
            if (isset($requestData->push_consent)) {
                $deviceData['push_consent'] = 
                    ($requestData->push_consent === 1 || 
                     $requestData->push_consent === '1' || 
                     $requestData->push_consent === true) ? 1 : 0;
            }
            
            if (isset($requestData->marketing_consent)) {
                $deviceData['marketing_consent'] = 
                    ($requestData->marketing_consent === 1 || 
                     $requestData->marketing_consent === '1' || 
                     $requestData->marketing_consent === true) ? 1 : 0;
            }
            
            // GERÇEK KULLANICI IP'SİNİ ALMA
            $deviceData['ip_address'] = $this->getRealUserIp();
            
            // Cihazı kaydet veya güncelle
            $result = $deviceModel->saveDevice($deviceData);
            
            if ($result) {
                log_message('info', "Cihaz bilgileri kaydedildi - User ID: $userId, Device UUID: " . 
                    $deviceData['device_uuid'] . ", Login Method: $loginMethod, IP: " . $deviceData['ip_address']);
            }
            
        } catch (\Exception $e) {
            log_message('error', 'Cihaz kaydetme hatası: ' . $e->getMessage());
        }
    }
    /**
 * Kullanıcının gerçek IP adresini al
 */
  private function getRealUserIp() 
    {
        if (!empty($_SERVER['HTTP_CF_CONNECTING_IP'])) {
            return $_SERVER['HTTP_CF_CONNECTING_IP'];
        }
        
        if (!empty($_SERVER['HTTP_X_REAL_IP'])) {
            return $_SERVER['HTTP_X_REAL_IP'];
        }
        
        if (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
            $ips = explode(',', $_SERVER['HTTP_X_FORWARDED_FOR']);
            return trim($ips[0]);
        }
        
        if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
            return $_SERVER['HTTP_CLIENT_IP'];
        }
        
        return $_SERVER['REMOTE_ADDR'] ?? '0.0.0.0';
    }

    /**
     * Kayıt İşlemi - DÜZELTME: Device bilgilerini doğru şekilde kaydet
     */
     public function register()
    {
        $data = array(
            'code'      => 'empty_code',
            'message'   => 'Empty Message'
        );

        try {
            $data_json = $this->request->getJSON();
            
            if (!$data_json) {
                return $this->respond([
                    'code'      => 'failed',
                    'message'   => 'JSON verisi alınamadı'
                ]);
            }

            $userModel = model('App\Models\UserModel');
            $tokenModel = model('App\Models\TokenModel');

            $validation = \Config\Services::validation();

            $rules = [
                'email' => 'required|valid_email',
                'password' => 'required|min_length[6]',
                'first_name' => 'required',
                'last_name' => 'required'
            ];

            $validation->setRules($rules);

            if (!$validation->withRequest($this->request)->run()) {
                return $this->respond([
                    'code'      => 'failed',
                    'message'   => 'Validasyon hatası: ' . implode(', ', $validation->getErrors())
                ]);
            }

            $existingUser = $userModel->where('mail', $data_json->email)->first();
            if ($existingUser) {
                return $this->respond([
                    'code'      => 'failed',
                    'message'   => 'Bu e-posta adresi zaten kayıtlı'
                ]);
            }

            $existingUsername = $userModel->where('username', $data_json->email)->first();
            if ($existingUsername) {
                return $this->respond([
                    'code'      => 'failed',
                    'message'   => 'Bu kullanıcı adı zaten kayıtlı'
                ]);
            }

            $verification_code = $this->generateEasyVerificationCode();
            
            $userData = [
                'mail' => $data_json->email,
                'username' => $data_json->email,
                'password' => $userModel->hash($data_json->password),
                'name_surname' => $data_json->first_name . ' ' . $data_json->last_name,
                'type' => 'USER',
                'language' => 'turkish',
                'activated' => '1',
                'registration_date' => date('Y-m-d H:i:s'),
                'mail_verified' => '0',
                'phone_verified' => '0',
                'verification_code' => $verification_code,
                'verification_sent_at' => date('Y-m-d H:i:s'),
                'verification_expires_at' => date('Y-m-d H:i:s', strtotime('+24 hours'))
            ];

            $user_id = $userModel->insert($userData);

            if (!$user_id) {
                return $this->respond([
                    'code'      => 'failed',
                    'message'   => 'Kullanıcı kaydedilemedi'
                ]);
            }

            $user = $userModel->find($user_id);
            if (!$user) {
                return $this->respond([
                    'code'      => 'failed',
                    'message'   => 'Kullanıcı bulunamadı'
                ]);
            }

            $responseData = [
                'localId' => $user_id,
                'display_name' => $user['name_surname'],
                'user_email' => $user['mail'],
                'code' => 'success',
                'message' => 'Kayıt başarılı! E-posta doğrulama kodu gönderildi.',
                'email_verification_required' => true,
                'verified' => '0',
                'mail_verified' => '0',
                'type' => 'USER'
            ];

            if (!empty($data_json->returnSecureToken)) {
                $tokenModel->where('date_last_access < \''.date('Y-m-d H:i:s', strtotime("-2 months")).'\'', NULL)
                            ->delete();

                $token = $userModel->hash_token($data_json->email . $data_json->password . time() . rand(1, 9999));
                
                $tokenData = [
                    'date_last_access' => date('Y-m-d H:i:s'),
                    'ip' => $_SERVER['REMOTE_ADDR'] ?? '0.0.0.0',
                    'username' => $user['username'],
                    'user_id' => $user_id,
                    'display_name' => $user['name_surname'],
                    'token' => $token,
                    'other' => ''
                ];

                $tokenModel->insert($tokenData);
                
                $responseData['token'] = $token;
                $responseData['expire_date'] = strtotime("+2 months");
                
                log_message('info', "Kayıt sırasında token oluşturuldu - User ID: {$user_id}");
            }

            // ✅ DÜZELTME: Register için login_method = 'email'
            if (!empty($data_json->device_uuid)) {
                $this->saveDeviceInfo($user_id, $data_json->email, $data_json, 'email');
            }

            // E-posta gönder
            try {
                $emailService = new \App\Services\EmailService();
                $emailSent = $emailService->sendWelcomeEmail(
                    $data_json->email, 
                    $user['name_surname'], 
                    $verification_code
                );

                if (!$emailSent) {
                    log_message('error', 'E-posta gönderilemedi: ' . $data_json->email);
                    $responseData['message'] = 'Kayıt başarılı! Ancak doğrulama e-postası gönderilemedi.';
                }
            } catch (\Exception $e) {
                log_message('error', 'EmailService hatası: ' . $e->getMessage());
                $responseData['message'] = 'Kayıt başarılı! E-posta gönderiminde sorun yaşandı.';
            }

            // Admin bildirimi (devam ediyor...)
            try {
                $notificationService = service('NotificationService');
                $notificationModel = model('App\Models\NotificationModel');

                $title = 'Yeni Üye Kaydı';
                $body = "{$user['name_surname']} ({$user['mail']}) sisteme kayıt oldu";

                $notificationData = [
                    'user_id' => $user_id,
                    'new_member_email' => $user['mail'],
                    'new_member_name' => $user['name_surname'],
                    'notification_type' => 'new_member_registration',
                    'click_action' => 'OPEN_USER_DETAIL'
                ];

                $admins = $userModel->where('type', 'ADMIN')->findAll();

                foreach ($admins as $admin) {
                    $data_not = [
                        'user_id' => $admin['id'],
                        'title' => $title,
                        'body' => $body,
                        'data' => json_encode($notificationData),
                        'target' => 'new_member_registration',
                        'status' => 'sent',
                        'created_by' => $user_id
                    ];
                    
                    $notification_id = $notificationModel->addNotification($data_not);
                    
                    $pushResult = $notificationService->sendToUser(
                        $admin['id'],
                        $title,
                        $body,
                        $notificationData
                    );
                }
            } catch (\Exception $e) {
                log_message('warning', 'Notification kaydedilemedi: ' . $e->getMessage());
            }

            return $this->respond($responseData);

        } catch (\Exception $e) {
            log_message('error', 'Register genel hatası: ' . $e->getMessage());
            
            return $this->respond([
                'code'      => 'failed',
                'message'   => 'Kayıt işlemi sırasında hata oluştu: ' . $e->getMessage()
            ]);
        }
    }

    /**
     * Kullanıcı Bilgilerini Getir
     */
    public function user()
    {
        $data = array(
            'code'      => 'empty_code',
            'message'   => 'Empty Message'
        );

        $data_json = $this->request->getJSON();

        $listingModel = model('App\Models\ListingModel');
        $userModel = model('App\Models\UserModel');
        $favoriteModel = model('App\Models\FavoriteModel');
        $tokenModel = model('App\Models\TokenModel');

        if(empty($_GET['token']))
        {
            return $this->respond(array(
                'code'      => 'failed',
                'message'   => 'Token missing'
            ));
        }

        $token = $_GET['token'];
        $user_token = $tokenModel->where('token', $token)->findAll(1);

        if(count($user_token) == 0)
        {
            return $this->respond(array(
                'code'      => 'failed',
                'message'   => 'Valid Token missing'
            ));
        }

        $user_id = $user_token[0]['user_id'];

        if(empty($_GET['user_id']))
        {
            return $this->respond(array(
                'code'      => 'failed',
                'message'   => 'User ID missing'
            ));
        }

        if($user_id != $_GET['user_id'])
        {
            return $this->respond(array(
                'code'      => 'failed',
                'message'   => 'Token missing permissions'
            ));
        }

        $results = $userModel->where('id',$user_id)->findAll(1);

        if(count($results) == 0)
        {
            return $this->respond(array(
                'code'      => 'failed',
                'message'   => 'User data missing'
            ));
        }

        $user = $results[0];

        $data['user_id'] = $user_id;
        $data['profile_url'] = getenv('WEBSITE_URL').'index.php/profile/'.$user['id'];
        $data['profile_display_name'] = $user['name_surname'];
        $data['profile_email'] = $user['mail'];

        $data['avatar_url'] = '';
        if(!empty($user['image_user_filename']))
            $data['avatar_url'] = getenv('WEBSITE_URL').'files/'.$user['image_user_filename'];

        $data['wdk_phone'] = $user['phone'];
        $data['verified'] = $user['mail_verified'];
        $data['wdk_facebook'] = $user['facebook_link'];
        $data['wdk_linkedin'] = $user['linkedin_link'];
        $data['wdk_instagram'] = $user['gplus_link'];
        $data['wdk_telegram'] = '';
        $data['wdk_twitter'] = $user['twitter_link'];

        $name_surname = explode(' ', $user['name_surname']);

        $data['user_email'] = $user['mail'];
        $data['type'] = $user['type'] ?? 'USER';
        $data['first_name'] = '';
        $data['last_name'] = '';

        if(isset($name_surname[0]))
            $data['first_name'] = $name_surname[0];

        if(isset($name_surname[1]))
            $data['last_name'] = $name_surname[1];

        $data['wdk_address'] = $user['address'];
        $data['wdk_city'] = $user['zip_city'];

        $data['message'] = 'User found and returning data';
        $data['code'] = 'success';

        return $this->respond($data);
    }

    /**
     * Kullanıcı Bilgilerini Güncelle
     */
    public function edit_user()
    {
        $data = array(
            'code'      => 'empty_code',
            'message'   => 'Empty Message'
        );

        $data_json = $this->request->getJSON();

        $listingModel = model('App\Models\ListingModel');
        $userModel = model('App\Models\UserModel');
        $favoriteModel = model('App\Models\FavoriteModel');
        $tokenModel = model('App\Models\TokenModel');

        if(empty($_GET['token']))
        {
            return $this->respond(array(
                'code'      => 'failed',
                'message'   => 'Token missing'
            ));
        }

        $token = $_GET['token'];
        $user_token = $tokenModel->where('token', $token)->findAll(1);

        if(count($user_token) == 0)
        {
            return $this->respond(array(
                'code'      => 'failed',
                'message'   => 'Valid Token missing'
            ));
        }

        $user_id = $user_token[0]['user_id'];

        // Admin kontrolü - Sadece admin userType değiştirebilir
        $admin_user = $userModel->where('id', $user_id)->findAll(1);
        $is_admin = false;
        $admin_type = 'USER';
        if(count($admin_user) > 0) {
            $admin_type = $admin_user[0]['type'] ?? 'USER';
            $is_admin = in_array($admin_type, ['ADMIN', 'SUPER_ADMIN']);
        }

        $validation = \Config\Services::validation();

        helper('text');

        $rules = array(
            array(
                'field' => 'user_email',
                'label' => __('Email', 'wpdirectorykit'),
                'rules' => 'required|valid_email'
            ),
            array(
                'field' => 'password',
                'label' => __('Password', 'wpdirectorykit'),
                'rules' => ''
            ),
            array(
                'field' => 'password_repeat',
                'label' => __('Repeat Password', 'wpdirectorykit'),
                'rules' => ''
            ),
            array(
                'field' => 'last_name',
                'label' => __('Last Name', 'wpdirectorykit'),
                'rules' => 'required'
            ),
            array(
                'field' => 'wdk_phone',
                'label' => __('Phone number', 'wpdirectorykit'),
                'rules' => 'required'
            ),
            array(
                'field' => 'wdk_address',
                'label' => __('Address', 'wpdirectorykit'),
                'rules' => ''
            ),
            array(
                'field' => 'wdk_city',
                'label' => __('City', 'wpdirectorykit'),
                'rules' => ''
            ),
            array(
                'field' => 'wdk_facebook',
                'label' => __('Facebook', 'wpdirectorykit'),
                'rules' => ''
            ),
            array(
                'field' => 'wdk_instagram',
                'label' => __('Instagram', 'wpdirectorykit'),
                'rules' => ''
            ),
            array(
                'field' => 'returnSecureToken',
                'label' => __('Token', 'wpdirectorykit'),
                'rules' => ''
            ),
            array(
                'field' => 'type',
                'label' => __('User Type', 'wpdirectorykit'),
                'rules' => ''
            ),
        );

        $prepared_rules = array();
        foreach($rules as $key=>$rule)
            if(!empty($rule['rules']))$prepared_rules[$rule['field']] = $rule;

        $validation->setRules($prepared_rules);

        if ($validation->withRequest($this->request)->run()) {
            $results = $userModel->where('mail', $data_json->user_email)
                                 ->where('id !=', $user_id)->findAll(1);

            if(count($results) > 0)
            {
                return $this->respond(array(
                    'code'      => 'failed',
                    'message'   => 'Email already exists in system'
                ));
            }

            $data_update = array(
                'ID'            => $user_id,
            );
    
            $meta = array(
                'first_name'    => $data_json->first_name,
                'last_name'     => $data_json->last_name,
                'display_name'  => $data_json->first_name.' '.$data_json->last_name,
                'nickname'      => $data_json->first_name.' '.$data_json->last_name,
                'wdk_phone'     => $data_json->wdk_phone,
                'wdk_address'   => $data_json->wdk_address,
                'wdk_city'      => $data_json->wdk_city,
                'wdk_facebook'  => $data_json->wdk_facebook,
                'wdk_instagram' => $data_json->wdk_instagram,
            );
    
            $data_update = array_merge($data_update, $meta);

            $data = [
                'phone' => $data_update['wdk_phone'],
                'gplus_link' => $data_update['wdk_instagram'],
                'facebook_link' => $data_update['wdk_facebook'],
                'name_surname' => $data_update['first_name'].' '.$data_update['last_name'],
                'address' => $data_update['wdk_address'],
                'zip_city' => $data_update['wdk_city'],
            ];

            // UserType güncellemesi (sadece admin yapabilir)
      /*      if(!empty($data_json->type) && $is_admin) {
                $allowed_types = ['USER', 'AGENT', 'ADMIN'];
                
                // Super admin tüm tipleri değiştirebilir
                if($admin_type === 'SUPER_ADMIN') {
                    $allowed_types[] = 'SUPER_ADMIN';
                }
                
                if(in_array($data_json->type, $allowed_types)) {
                    $data['type'] = $data_json->type;
                    log_message('info', "Admin {$user_id} changed user type to: {$data_json->type}");
                } else {
                    log_message('warning', "Invalid user type attempted: {$data_json->type} by admin {$user_id}");
                }
            } else if(!empty($data_json->type) && !$is_admin) {
                // Admin olmayan kullanıcı type değiştirmeye çalışıyor
                log_message('warning', "Non-admin user {$user_id} attempted to change user type to: {$data_json->type}");
                return $this->respond(array(
                    'code'      => 'failed',
                    'message'   => 'You do not have permission to change user type'
                ));
            }*/

            if(!empty($data_json->password))
            {
                $data['password'] = $userModel->hash($data_json->password);
            }

            $userModel->update($user_id, $data);

            $user_fetched = $userModel->where('id', $user_id)->findAll(1);

            if(count($user_fetched) == 0)
            {
                return $this->respond(array(
                    'code'      => 'failed',
                    'message'   => 'User data lost, id not found'
                ));
            }

            $user = $user_fetched[0];

            $data['display_name'] = $user['name_surname'];
            $data['user_email'] = $user['mail'];
         //   $data['type'] = $user['type'] ?? 'USER';

            $data = array_merge($data_update, $data);

            $data['message'] = __('Update successfuly', 'wpdirectorykit');
            $data['code'] = 'success';

            return $this->respond($data);
        }

        return $this->respond(array(
            'code'      => 'failed',
            'message'   => join("\n", $validation->getErrors())
        ));
    }

/**
 * Sosyal Medya ile Kayıt/Giriş - GÜNCELLEME: Cihaz bilgileri eklendi
 */
   public function auth_register()
    {
        $data = array(
            'code'      => 'empty_code',
            'message'   => 'Empty Message'
        );

        $data_json = $this->request->getJSON();

        $listingModel = model('App\Models\ListingModel');
        $userModel = model('App\Models\UserModel');
        $favoriteModel = model('App\Models\FavoriteModel');
        $tokenModel = model('App\Models\TokenModel');
        $deviceModel = model('App\Models\DeviceModel');

        $validation = \Config\Services::validation();

        helper('text');

        $rules = array(
            array(
                'field' => 'email',
                'label' => __('Email', 'SatışaHazır'),
                'rules' => 'required|valid_email'
            ),
            array(
                'field' => 'auth_uid',
                'label' => __('auth_uid', 'SatışaHazır'),
                'rules' => 'required'
            ),
            array(
                'field' => 'auth_type',
                'label' => __('auth_type', 'SatışaHazır'),
                'rules' => 'required'
            ),
            array(
                'field' => 'displayName',
                'label' => __('displayName', 'SatışaHazır'),
                'rules' => ''
            ),
            array(
                'field' => 'returnSecureToken',
                'label' => __('r', 'SatışaHazır'),
                'rules' => ''
            ),
        );

        $prepared_rules = array();
        foreach($rules as $key=>$rule)
        {
            if(!empty($rule['rules']))
            {
                $prepared_rules[$rule['field']] = $rule;
            }
            elseif(empty($data_json->{$rule['field']}))
            {
                $data_json->{$rule['field']} = '';
            }
        }

        $validation->setRules($prepared_rules);

        if ($validation->withRequest($this->request)->run()) {
            // ✅ YENİ: auth_type'ı login_method'a çevir
            $loginMethod = 'unknown';
            if (!empty($data_json->auth_type)) {
                $authType = strtolower($data_json->auth_type);
                
                // Flutter'dan gelen değerler: 'gmail', 'facebook', 'twitter', 'apple'
                if ($authType === 'gmail') {
                    $loginMethod = 'google';
                } else if ($authType === 'facebook') {
                    $loginMethod = 'facebook';
                } else if ($authType === 'apple') {
                    $loginMethod = 'apple';
                } else if ($authType === 'twitter') {
                    $loginMethod = 'facebook'; // veya 'twitter' (tabloda tanımlıysa)
                }
            }

            $results = $userModel->where('auth_gmail', $data_json->email)
                                 ->findAll(1);

            if(count($results) > 0)
            {
                // Mevcut kullanıcı - Giriş yap
                $user_data = $results[0];
                
                if($data_json->returnSecureToken)
                {
                    $tokenModel->where('date_last_access < \''.date('Y-m-d H:i:s', strtotime("-2 months")).'\'', NULL)
                               ->delete();                    

                    $ip = '';
                    if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
                        $ip = $_SERVER['HTTP_CLIENT_IP'];
                    } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
                        $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
                    } else {
                        $ip = $_SERVER['REMOTE_ADDR'];
                    }

                    $token = $userModel->hash_token($data_json->email.$data_json->password.time().rand(1,9999));

                    $data = array();
                    $data['date_last_access'] = date('Y-m-d H:i:s');
                    $data['ip'] = $ip;
                    $data['username'] = $user_data['username'];
                    $data['user_id'] = $user_data['id'];
                    $data['display_name'] = $user_data['name_surname'];
                    $data['token'] = $token;
                    $data['other'] = '';
            
                    $insert_idtoken = $tokenModel->insert($data);

                    // ✅ DÜZELTME: Sosyal giriş için login_method kaydet
                    if(!empty($data_json->device_uuid)) {
                        $this->saveDeviceInfoFromJson($user_data['id'], $user_data['mail'], $data_json, $loginMethod);
                    }

                    return $this->respond(array(
                        'localId'       => $user_data['id'],
                        'display_name'  => $user_data['name_surname'],
                        'user_email'    => $user_data['mail'],
                        'code'          => 'success',
                        'message'       => 'Login successfuly',
                        'token'         => $token,
                        'expire_date'   => strtotime("+2 months"),  
                        'verified'      => $user_data['mail_verified'],
                        'mail_verified' => $user_data['mail_verified'],
                        'type'          => $user_data['type'] ?? 'USER'
                    ));
                }
                
                return $this->respond(array(
                    'code'      => 'failed',
                    'message'   => 'Email already exists in system',
                    'type'      => $user_data['type'] ?? 'USER'
                ));
            }

            // Yeni kullanıcı kaydı
            $meta = array(
                'user_email'    => $data_json->email,
                'auth_gmail'    => $data_json->email,
                'auth_uid'      => $data_json->auth_uid,
                'first_name'    => $data_json->first_name,
                'last_name'     => $data_json->last_name,
                'display_name'  => $data_json->first_name.' '.$data_json->last_name,
            );

            $data_update = $meta;
          
            $data = [
                'name_surname' => $data_update['display_name'],
                'mail' => $data_update['user_email'],
                'username' => $data_update['user_email'],
                'password' => $userModel->hash($data_json->password),
                'auth_gmail' => $data_update['auth_gmail'],
                'auth_uid' => $data_update['auth_uid'],
                'type' => 'USER',
                'language' => 'english',
                'activated' => '1',
                'registration_date' => date('Y-m-d H:i:s'),
                'last_login' => date('Y-m-d H:i:s'),
                'mail_verified' => '1',
            ];

            $user_id = $userModel->insert($data);

            if(empty($user_id))
            {
                return $this->respond(array(
                    'code'      => 'failed',
                    'message'   => 'Insertion registration failed'
                ));
            }

            $user_fetched = $userModel->where('id', $user_id)->findAll(1);

            if(count($user_fetched) == 0)
            {
                return $this->respond(array(
                    'code'      => 'failed',
                    'message'   => 'User data lost, id not found'
                ));
            }

            $user = $user_fetched[0];

            $data['display_name'] = $user['name_surname'];
            $data['user_email'] = $user['mail'];
            $data['type'] = $user['type'] ?? 'USER';

            unset($data['password']);

            $data = array_merge($data_update, $data);

            if(!empty($data_json->returnSecureToken))
            {
                $tokenModel->where('date_last_access < \''.date('Y-m-d H:i:s', strtotime("-2 months")).'\'', NULL)
                            ->delete();                    

                $ip = '';
                if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
                    $ip = $_SERVER['HTTP_CLIENT_IP'];
                } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
                    $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
                } else {
                    $ip = $_SERVER['REMOTE_ADDR'];
                }

                $token = $userModel->hash_token($data_json->email.$data_json->password.time().rand(1,9999));

                $data_token = array();
                $data_token['date_last_access'] = date('Y-m-d H:i:s');
                $data_token['ip'] = $ip;
                $data_token['username'] = $user['username'];
                $data_token['user_id'] = $user_id;
                $data_token['display_name'] = $data['display_name'];
                $data_token['token'] = $token;
                $data_token['other'] = '';

                $insert_idtoken = $tokenModel->insert($data_token);

                $data = array_merge($data_token, $data);
                
                $data['localId'] = $user_id;
                $data['expire_date'] = strtotime("+2 months");
                $data['verified'] = '1';
                $data['mail_verified'] = '1';
                $data['type'] = $user['type'] ?? 'USER';
            }

            // ✅ DÜZELTME: Yeni kullanıcı için login_method kaydet
            if(!empty($data_json->device_uuid)) {
                $this->saveDeviceInfoFromJson($user_id, $data['user_email'], $data_json, $loginMethod);
            }

            // Admin bildirimi
            try {
                $notificationService = service('NotificationService');
                $notificationModel = model('App\Models\NotificationModel');

                $title = 'Yeni Üye Kaydı';
                $body = "{$user['name_surname']} ({$user['mail']}) sisteme kayıt oldu";

                $notificationData = [
                    'user_id' => $user_id,
                    'new_member_email' => $user['mail'],
                    'new_member_name' => $user['name_surname'],
                    'notification_type' => 'new_member_registration',
                    'click_action' => 'OPEN_USER_DETAIL'
                ];

                $admins = $userModel->where('type', 'ADMIN')->findAll();

                foreach ($admins as $admin) {
                    $data_not = [
                        'user_id' => $admin['id'],
                        'title' => $title,
                        'body' => $body,
                        'data' => json_encode($notificationData),
                        'target' => 'new_member_registration',
                        'status' => 'sent',
                        'created_by' => $user_id
                    ];
                    
                    $notification_id = $notificationModel->addNotification($data_not);
                    
                    $pushResult = $notificationService->sendToUser(
                        $admin['id'],
                        $title,
                        $body,
                        $notificationData
                    );
                }
            } catch (\Exception $e) {
                log_message('warning', 'Notification kaydedilemedi: ' . $e->getMessage());
            }

            $data['message'] = __('Register successfuly', 'wpdirectorykit');
            $data['code'] = 'success';

            return $this->respond($data);
        }

        return $this->respond(array(
            'code'      => 'failed',
            'message'   => join("\n", $validation->getErrors())
        ));
    }


/**
 * YENİ: JSON objeden cihaz bilgilerini kaydet helper metodu
 * saveDeviceInfo'nun JSON obje alan versiyonu
 */
  private function saveDeviceInfoFromJson($userId, $userEmail, $data_json, $loginMethod = 'unknown')
    {
        try {
            $deviceModel = model('App\Models\DeviceModel');
            
            // Cihaz verileri hazırla
            $deviceData = [
                'user_id' => $userId,
                'email' => $userEmail,
                'device_uuid' => isset($data_json->device_uuid) ? $data_json->device_uuid : '',
                'fcmToken' => isset($data_json->fcmToken) ? $data_json->fcmToken : '',
                'push_token' => isset($data_json->fcmToken) ? $data_json->fcmToken : '',
                'is_active' => 1,
                'last_active' => date('Y-m-d H:i:s'),
                'login_method' => $loginMethod // ✅ YENİ: login_method eklendi
            ];
            
            // Platform bilgileri ekle
            if (isset($data_json->platform)) {
                $deviceData['platform'] = $data_json->platform;
            }
            
            if (isset($data_json->device_name)) {
                $deviceData['device_name'] = $data_json->device_name;
            }
            
            if (isset($data_json->system_name)) {
                $deviceData['system_name'] = $data_json->system_name;
            }
            
            if (isset($data_json->system_version)) {
                $deviceData['system_version'] = $data_json->system_version;
            }
            
            if (isset($data_json->device_model)) {
                $deviceData['device_model'] = $data_json->device_model;
            }
            
            if (isset($data_json->brand)) {
                $deviceData['brand'] = $data_json->brand;
            }
            
            if (isset($data_json->device_brand)) {
                $deviceData['device_brand'] = $data_json->device_brand;
            }
            
            if (isset($data_json->manufacturer)) {
                $deviceData['manufacturer'] = $data_json->manufacturer;
            }
            
            if (isset($data_json->android_version)) {
                $deviceData['android_version'] = $data_json->android_version;
            }
            
            if (isset($data_json->app_version)) {
                $deviceData['app_version'] = $data_json->app_version;
            }
            
            if (isset($data_json->app_build_number)) {
                $deviceData['app_build_number'] = $data_json->app_build_number;
            }
            
            // Dil ve ülke bilgisi
            if (isset($data_json->language)) {
                $deviceData['language'] = $data_json->language;
            }
            
            if (isset($data_json->country_code)) {
                $deviceData['country_code'] = $data_json->country_code;
            }
            
            if (isset($data_json->country)) {
                $deviceData['country'] = $data_json->country;
            }
            
            if (isset($data_json->region)) {
                $deviceData['region'] = $data_json->region;
            }
            
            // İzin durumları
            if (isset($data_json->push_consent)) {
                $deviceData['push_consent'] = $data_json->push_consent ? 1 : 0;
            }
            
            if (isset($data_json->marketing_consent)) {
                $deviceData['marketing_consent'] = $data_json->marketing_consent ? 1 : 0;
            }
            
            // IP adresi
            $deviceData['ip_address'] = $this->getRealUserIp();
            
            // Cihazı kaydet veya güncelle
            $result = $deviceModel->saveDevice($deviceData);
            
            if ($result) {
                log_message('info', "Sosyal giriş - Cihaz bilgileri kaydedildi - User ID: $userId, Device UUID: " . 
                    $deviceData['device_uuid'] . ", Login Method: $loginMethod");
            } else {
                log_message('warning', "Sosyal giriş - Cihaz bilgileri kaydedilemedi - User ID: $userId");
            }
            
        } catch (\Exception $e) {
            log_message('error', 'Sosyal giriş - Cihaz kaydetme hatası: ' . $e->getMessage());
        }
    }

    /**
     * E-posta Doğrulama Kodu Gönder
     */
    public function send_verification_email()
    {
        $data = [
            'code'      => 'empty_code',
            'message'   => 'Empty Message'
        ];

        $data_json = $this->request->getJSON();
        $userModel = model('App\Models\UserModel');

        if (empty($data_json->email)) {
            return $this->respond([
                'code'      => 'failed',
                'message'   => 'E-posta adresi gerekli'
            ]);
        }

        $email = $data_json->email;
        $user = $userModel->where('mail', $email)->first();

        if (!$user) {
            return $this->respond([
                'code'      => 'failed',
                'message'   => 'Bu e-posta adresi ile kayıtlı kullanıcı bulunamadı'
            ]);
        }

        if ($user['mail_verified'] == 1) {
            return $this->respond([
                'code'      => 'failed',
                'message'   => 'E-posta adresi zaten doğrulanmış'
            ]);
        }

        try {
            $verification_code = $this->generateEasyVerificationCode();
            
            // Rate limiting
            $lastSent = $user['verification_sent_at'] ?? null;
            if ($lastSent && (time() - strtotime($lastSent)) < 60) {
                $waitTime = 60 - (time() - strtotime($lastSent));
                return $this->respond([
                    'code'      => 'failed',
                    'message'   => "Lütfen {$waitTime} saniye bekleyip tekrar deneyin"
                ]);
            }

            $updateData = [
                'verification_code' => $verification_code,
                'verification_sent_at' => date('Y-m-d H:i:s'),
                'verification_expires_at' => date('Y-m-d H:i:s', strtotime('+24 hours'))
            ];

            $userModel->update($user['id'], $updateData);

            try {
                $emailService = new \App\Services\EmailService();
                $emailSent = $emailService->sendVerificationEmail(
                    $email, 
                    $user['name_surname'], 
                    $verification_code
                );

                if ($emailSent) {
                    log_message('info', "Doğrulama e-postası gönderildi: {$email}");
                    
                    return $this->respond([
                        'code'      => 'success',
                        'message'   => 'Doğrulama kodu e-postanıza gönderildi',
                        'expires_at' => $updateData['verification_expires_at']
                    ]);
                } else {
                    return $this->respond([
                        'code'      => 'failed',
                        'message'   => 'E-posta gönderilemedi. SMTP ayarlarını kontrol edin.'
                    ]);
                }

            } catch (\Exception $emailError) {
                log_message('error', "EmailService hatası: " . $emailError->getMessage());
                
                return $this->respond([
                    'code'      => 'failed',
                    'message'   => 'E-posta servisi hatası: ' . $emailError->getMessage()
                ]);
            }

        } catch (\Exception $e) {
            log_message('error', 'E-posta doğrulama gönderme hatası: ' . $e->getMessage());
            
            return $this->respond([
                'code'      => 'failed',
                'message'   => 'E-posta gönderilirken hata oluştu: ' . $e->getMessage()
            ]);
        }
    }

    /**
     * E-posta Doğrulama Kodunu Kontrol Et
     */
    public function verify_email_code()
    {
        $data_json = $this->request->getJSON();
        $userModel = model('App\Models\UserModel');
        $tokenModel = model('App\Models\TokenModel');

        if (empty($data_json->email) || empty($data_json->verification_code)) {
            return $this->respond([
                'code'      => 'failed',
                'message'   => 'E-posta adresi ve doğrulama kodu gerekli'
            ]);
        }

        $email = $data_json->email;
        $code = $data_json->verification_code;

        $user = $userModel->where('mail', $email)
                         ->where('verification_code', $code)
                         ->first();

        if (!$user) {
            return $this->respond([
                'code'      => 'failed',
                'message'   => 'Geçersiz doğrulama kodu'
            ]);
        }

        if (strtotime($user['verification_expires_at']) < time()) {
            return $this->respond([
                'code'      => 'failed',
                'message'   => 'Doğrulama kodu süresi dolmuş. Yeni bir kod talep edin.'
            ]);
        }

        if ($user['mail_verified'] == 1) {
            return $this->respond([
                'code'      => 'success',
                'message'   => 'E-posta adresi zaten doğrulanmış',
                'already_verified' => true
            ]);
        }

        try {
            $updateData = [
                'mail_verified' => 1,
                'verification_code' => null,
                'verification_expires_at' => null,
                'email_verified_at' => date('Y-m-d H:i:s')
            ];

            $userModel->update($user['id'], $updateData);

            $responseData = [
                'code'      => 'success',
                'message'   => 'E-posta adresiniz başarıyla doğrulandı!',
                'user_id'   => $user['id'],
                'verified'  => '1',
                'mail_verified' => '1',
                'type'      => $user['type'] ?? 'USER'
            ];

            // Token oluştur
            if (!empty($data_json->returnSecureToken)) {
                $tokenModel->where('date_last_access < \''.date('Y-m-d H:i:s', strtotime("-2 months")).'\'', NULL)
                           ->delete();

                $ip = '';
                if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
                    $ip = $_SERVER['HTTP_CLIENT_IP'];
                } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
                    $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
                } else {
                    $ip = $_SERVER['REMOTE_ADDR'];
                }

                $token = $userModel->hash_token($email . time() . rand(1,9999));

                $tokenData = [
                    'date_last_access' => date('Y-m-d H:i:s'),
                    'ip' => $ip,
                    'username' => $user['username'],
                    'user_id' => $user['id'],
                    'display_name' => $user['name_surname'],
                    'token' => $token,
                    'other' => ''
                ];

                $tokenModel->insert($tokenData);

                $responseData['token'] = $token;
                $responseData['expire_date'] = strtotime("+2 months");
                $responseData['display_name'] = $user['name_surname'];
                $responseData['user_email'] = $user['mail'];
                $responseData['localId'] = $user['id'];

                log_message('info', "E-posta doğrulama sonrası token oluşturuldu - User ID: {$user['id']}");
            }

            return $this->respond($responseData);

        } catch (\Exception $e) {
            log_message('error', 'E-posta doğrulama hatası: ' . $e->getMessage());
            
            return $this->respond([
                'code'      => 'failed',
                'message'   => 'E-posta doğrulanırken hata oluştu: ' . $e->getMessage()
            ]);
        }
    }

    /**
     * Şifre Sıfırlama Kodu Gönder  
     */
    public function send_password_reset_code()
    {
        $data = [
            'code'      => 'empty_code',
            'message'   => 'Empty Message'
        ];

        $data_json = $this->request->getJSON();
        $userModel = model('App\Models\UserModel');

        if (empty($data_json->email)) {
            return $this->respond([
                'code'      => 'failed',
                'message'   => 'E-posta adresi gerekli'
            ]);
        }

        $email = $data_json->email;
        $user = $userModel->where('mail', $email)->first();

        if (!$user) {
            return $this->respond([
                'code'      => 'failed',
                'message'   => 'Bu e-posta adresi ile kayıtlı kullanıcı bulunamadı'
            ]);
        }

        // E-posta doğrulanmış mı kontrol et
        if ($user['mail_verified'] != 1) {
            return $this->respond([
                'code'      => 'failed',
                'message'   => 'Önce e-posta adresinizi doğrulamanız gerekiyor'
            ]);
        }

        try {
            // Rate limiting
            $lastSent = $user['reset_code_sent_at'] ?? null;
            if ($lastSent && (time() - strtotime($lastSent)) < 60) {
                $waitTime = 60 - (time() - strtotime($lastSent));
                return $this->respond([
                    'code'      => 'failed',
                    'message'   => "Lütfen {$waitTime} saniye bekleyip tekrar deneyin"
                ]);
            }

            $reset_code = $this->generateEasyVerificationCode();
            
            $updateData = [
                'reset_code' => $reset_code,
                'reset_code_sent_at' => date('Y-m-d H:i:s'),
                'reset_code_expires_at' => date('Y-m-d H:i:s', strtotime('+30 minutes'))
            ];

            $userModel->update($user['id'], $updateData);

            try {
                $emailService = new \App\Services\EmailService();
                $emailSent = $emailService->sendPasswordResetEmail(
                    $email, 
                    $user['name_surname'], 
                    $reset_code
                );

                if ($emailSent) {
                    log_message('info', "Şifre sıfırlama kodu gönderildi: {$email}");
                    
                    return $this->respond([
                        'code'      => 'success',
                        'message'   => 'Şifre sıfırlama kodu e-postanıza gönderildi',
                        'expires_at' => $updateData['reset_code_expires_at']
                    ]);
                } else {
                    return $this->respond([
                        'code'      => 'failed',
                        'message'   => 'E-posta gönderilemedi. Lütfen tekrar deneyin.'
                    ]);
                }

            } catch (\Exception $emailError) {
                log_message('error', "EmailService hatası: " . $emailError->getMessage());
                
                return $this->respond([
                    'code'      => 'failed',
                    'message'   => 'E-posta servisi hatası: ' . $emailError->getMessage()
                ]);
            }

        } catch (\Exception $e) {
            log_message('error', 'Şifre sıfırlama kodu gönderme hatası: ' . $e->getMessage());
            
            return $this->respond([
                'code'      => 'failed',
                'message'   => 'İşlem sırasında hata oluştu: ' . $e->getMessage()
            ]);
        }
    }

    /**
     * Şifre Sıfırlama Kodunu Doğrula
     */
    public function verify_password_reset_code()
    {
        $data_json = $this->request->getJSON();
        $userModel = model('App\Models\UserModel');

        if (empty($data_json->email) || empty($data_json->reset_code)) {
            return $this->respond([
                'code'      => 'failed',
                'message'   => 'E-posta adresi ve sıfırlama kodu gerekli'
            ]);
        }

        $email = $data_json->email;
        $code = $data_json->reset_code;

        $user = $userModel->where('mail', $email)
                         ->where('reset_code', $code)
                         ->first();

        if (!$user) {
            return $this->respond([
                'code'      => 'failed',
                'message'   => 'Geçersiz sıfırlama kodu'
            ]);
        }

        if (empty($user['reset_code_expires_at']) || strtotime($user['reset_code_expires_at']) < time()) {
            return $this->respond([
                'code'      => 'failed',
                'message'   => 'Sıfırlama kodu süresi dolmuş. Yeni bir kod talep edin.'
            ]);
        }

        try {
            $updateData = [
                'reset_code_verified' => 1,
                'reset_code_verified_at' => date('Y-m-d H:i:s')
            ];

            $userModel->update($user['id'], $updateData);

            return $this->respond([
                'code'      => 'success',
                'message'   => 'Sıfırlama kodu doğrulandı. Yeni şifrenizi belirleyebilirsiniz.',
                'user_id'   => $user['id']
            ]);

        } catch (\Exception $e) {
            log_message('error', 'Şifre sıfırlama kodu doğrulama hatası: ' . $e->getMessage());
            
            return $this->respond([
                'code'      => 'failed',
                'message'   => 'İşlem sırasında hata oluştu: ' . $e->getMessage()
            ]);
        }
    }

    /**
     * Yeni Şifre Belirle
     */
    public function reset_password_with_code()
    {
        $data_json = $this->request->getJSON();
        $userModel = model('App\Models\UserModel');

        if (empty($data_json->email) || empty($data_json->reset_code) || empty($data_json->new_password)) {
            return $this->respond([
                'code'      => 'failed',
                'message'   => 'E-posta, sıfırlama kodu ve yeni şifre gerekli'
            ]);
        }

        $email = $data_json->email;
        $code = $data_json->reset_code;
        $new_password = $data_json->new_password;

        if (strlen($new_password) < 6) {
            return $this->respond([
                'code'      => 'failed',
                'message'   => 'Şifre en az 6 karakter olmalıdır'
            ]);
        }

        $user = $userModel->where('mail', $email)
                         ->where('reset_code', $code)
                         ->first();

        if (!$user) {
            return $this->respond([
                'code'      => 'failed',
                'message'   => 'Geçersiz sıfırlama kodu'
            ]);
        }

        if (empty($user['reset_code_expires_at']) || strtotime($user['reset_code_expires_at']) < time()) {
            return $this->respond([
                'code'      => 'failed',
                'message'   => 'Sıfırlama kodu süresi dolmuş. Yeni bir kod talep edin.'
            ]);
        }

        if (empty($user['reset_code_verified']) || $user['reset_code_verified'] != 1) {
            return $this->respond([
                'code'      => 'failed',
                'message'   => 'Önce sıfırlama kodunu doğrulamanız gerekiyor'
            ]);
        }

        try {
            $hashedPassword = $userModel->hash($new_password);
            
            $updateData = [
                'password' => $hashedPassword,
                'reset_code' => null,
                'reset_code_sent_at' => null,
                'reset_code_expires_at' => null,
                'reset_code_verified' => 0,
                'reset_code_verified_at' => null,
                'password_updated_at' => date('Y-m-d H:i:s')
            ];

            $userModel->update($user['id'], $updateData);

            // Tüm tokenları sil (güvenlik için)
            try {
                $tokenModel = model('App\Models\TokenModel');
                $tokenModel->where('user_id', $user['id'])->delete();
            } catch (\Exception $e) {
                log_message('warning', 'Token silme hatası: ' . $e->getMessage());
            }

            log_message('info', "Şifre başarıyla sıfırlandı - User ID: {$user['id']}, Email: {$email}");

            // Bilgilendirme e-postası gönder
            try {
                $emailService = new \App\Services\EmailService();
                $emailService->sendPasswordChangedNotificationEmail(
                    $email, 
                    $user['name_surname']
                );
            } catch (\Exception $e) {
                log_message('warning', 'Şifre değişikliği bildirim e-postası gönderilemedi: ' . $e->getMessage());
            }

            return $this->respond([
                'code'      => 'success',
                'message'   => 'Şifreniz başarıyla değiştirildi. Yeni şifrenizle giriş yapabilirsiniz.',
                'user_id'   => $user['id']
            ]);

        } catch (\Exception $e) {
            log_message('error', 'Şifre sıfırlama hatası: ' . $e->getMessage());
            
            return $this->respond([
                'code'      => 'failed',
                'message'   => 'Şifre değiştirirken hata oluştu: ' . $e->getMessage()
            ]);
        }
    }

    /**
     * Cihaz Kaydı
     */
    public function registerDevice()
    {
        $data = array(
            'code'      => 'empty_code',
            'message'   => 'Empty Message'
        );

        $data_json = $this->request->getJSON();

        $listingModel = model('App\Models\ListingModel');
        $userModel = model('App\Models\UserModel');
        $favoriteModel = model('App\Models\FavoriteModel');
        $tokenModel = model('App\Models\TokenModel');
        $deviceModel = model('App\Models\DeviceModel');

        $validation = \Config\Services::validation();

        helper('text');

        $rules = array(
            array(
                'field' => 'user_id',
                'label' => __('User', 'wpdirectorykit'),
                'rules' => 'required'
            ),
            array(
                'field' => 'user_email',
                'label' => __('E-posta', 'wpdirectorykit'),
                'rules' => 'required|valid_email'
            ),
        );

        $prepared_rules = array();
        foreach($rules as $key=>$rule)
        {
            if(!empty($rule['rules']))
            {
                $prepared_rules[$rule['field']] = $rule;
            }
            elseif(empty($data_json->{$rule['field']}))
            {
                $data_json->{$rule['field']} = '';
            }
        }

        $validation->setRules($prepared_rules);

        if ($validation->withRequest($this->request)->run()) {
            $user_fetched = $userModel->where('id', $data_json->user_id)->findAll(1);

            if(count($user_fetched) == 0)
            {
                return $this->respond(array(
                    'code'      => 'failed',
                    'message'   => 'User data lost, id not found'
                ));
            }

            $user = $user_fetched[0];

            $data['display_name'] = $user['name_surname'];
            $data['user_email'] = $user['mail'];
            
            $meta_device = array(
                'user_id'         => $data_json->user_id,
                'user_email'      => isset($data_json->user_email) ? $data_json->user_email : '',   
                'fcmToken'        => isset($data_json->fcmToken) ? $data_json->fcmToken : '', 
                'platform'        => isset($data_json->platform) ? $data_json->platform  : '', 
                'device_name'     => isset($data_json->device_name) ? $data_json->device_name : '', 
                'system_name'     => isset($data_json->system_name) ? $data_json->system_name : '', 
                'system_version'  => isset($data_json->system_version) ? $data_json->system_version : '', 
                'brand'           => isset($data_json->brand) ? $data_json->brand : '', 
                'device_brand'    => isset($data_json->device_brand) ? $data_json->device_brand : '', 
                'device_model'    => isset($data_json->device_model) ? $data_json->device_model : '', 
                'android_version' => isset($data_json->android_version) ? $data_json->android_version : '', 
                'manufacturer'    => isset($data_json->manufacturer) ? $data_json->manufacturer : '', 
            );
            
            $device = [
                'user_id' => $meta_device['user_id'],
                'email' => $meta_device['user_email'],
                'fcmToken' => $meta_device['fcmToken'],
                'platform' => $meta_device['platform'],
                'device_name' => $meta_device['device_name'],
                'system_name' => $meta_device['system_name'],
                'system_version' => $meta_device['system_version'], 
                'brand' => $meta_device['brand'],
                'device_brand' => $meta_device['device_brand'],
                'device_model' => $meta_device['device_model'],
                'android_version' => $meta_device['android_version'],
                'manufacturer' => $meta_device['manufacturer'],
            ];
            
            try {
                $user_id_device = $deviceModel->insert($device);
            } catch (\Exception $e) {
                log_message('warning', 'Device tablosu bulunamadı: ' . $e->getMessage());
            }

            $data['message'] = __('Register Device successfuly', 'wpdirectorykit');
            $data['code'] = 'success';

            return $this->respond($data);
        }

        return $this->respond(array(
            'code'      => 'failed',
            'message'   => join("\n", $validation->getErrors())
        ));
    }

    /**
     * Güvenli Hesap Silme
     */
    public function delete()
    {
        $data = array(
            'code'      => 'empty_code',
            'message'   => 'Empty Message'
        );

        $data_json = $this->request->getJSON();
        $userModel = model('App\Models\UserModel');
        $tokenModel = model('App\Models\TokenModel');
        
        // DeletedUserModel'i güvenli şekilde yükle
        try {
            $deletedUserModel = model('App\Models\DeletedUserModel');
        } catch (\Exception $e) {
            log_message('error', 'DeletedUserModel yüklenemedi: ' . $e->getMessage());
            $deletedUserModel = null;
        }

        // Token Kontrolü
        if(empty($_GET['token']))
        {
            return $this->respond(array(
                'code'      => 'failed',
                'message'   => 'Token eksik'
            ));
        }

        $token = $_GET['token'];
        $user_token = $tokenModel->where('token', $token)->findAll(1);

        if(count($user_token) == 0)
        {
            return $this->respond(array(
                'code'      => 'failed',
                'message'   => 'Geçersiz token'
            ));
        }

        $user_id = $user_token[0]['user_id'];

        if(empty($_GET['user_id']))
        {
            return $this->respond(array(
                'code'      => 'failed',
                'message'   => 'Kullanıcı ID eksik'
            ));
        }

        if($user_id != $_GET['user_id'])
        {
            return $this->respond(array(
                'code'      => 'failed',
                'message'   => 'Token yetkisi yetersiz'
            ));
        }

        // Şifre kontrolü - ZORUNLU
        if(empty($data_json->password))
        {
            return $this->respond(array(
                'code'      => 'failed',
                'message'   => 'Hesabınızı silmek için şifrenizi girmelisiniz'
            ));
        }

        // Kullanıcı bilgilerini al
        $user = $userModel->where('id', $user_id)->first();
        
        if(!$user)
        {
            return $this->respond(array(
                'code'      => 'failed',
                'message'   => 'Kullanıcı bulunamadı'
            ));
        }

        // ŞİFRE KONTROLÜ
        $provided_password_hash = $userModel->hash($data_json->password);
        if($user['password'] !== $provided_password_hash)
        {
            log_message('warning', 'Başarısız hesap silme denemesi - Kullanıcı ID: ' . $user_id . ', IP: ' . $this->request->getIPAddress());
            
            return $this->respond(array(
                'code'      => 'failed',
                'message'   => 'Şifreniz yanlış. Hesap silme işlemi gerçekleştirilemez.'
            ));
        }

        // Ek güvenlik kontrolleri
        $current_ip = $this->request->getIPAddress();
        $token_ip = $user_token[0]['ip'];
        
        $token_date = strtotime($user_token[0]['date_last_access']);
        $now = time();
        $token_age_hours = ($now - $token_date) / 3600;
        
        if($token_age_hours > 24) // 24 saatten eski token'lar için ek doğrulama
        {
            return $this->respond(array(
                'code'      => 'failed',
                'message'   => 'Güvenlik nedeniyle lütfen yeniden giriş yapın ve işlemi tekrarlayın'
            ));
        }

        // Onay metni kontrolü (isteğe bağlı)
        if(!empty($data_json->confirmation_text))
        {
            $expected_text = "HESABIMI SIL";
            if(strtoupper(trim($data_json->confirmation_text)) !== $expected_text)
            {
                return $this->respond(array(
                    'code'      => 'failed',
                    'message'   => 'Onay metni yanlış. Lütfen "HESABIMI SIL" yazın'
                ));
            }
        }

        try {
            $db = \Config\Database::connect();
            $db->transStart();

            // Kullanıcı verilerini arşivle
            if ($deletedUserModel) {
                try {
                    $deleted_user_data = [
                        'original_user_id' => $user['id'],
                        'username' => $user['username'],
                        'mail' => $user['mail'],
                        'name_surname' => $user['name_surname'],
                        'phone' => $user['phone'] ?? '',
                        'type' => $user['type'] ?? 'USER',
                        'registration_date' => $user['registration_date'],
                        'deletion_date' => date('Y-m-d H:i:s'),
                        'deletion_ip' => $current_ip,
                        'deletion_reason' => $data_json->deletion_reason ?? 'Kullanıcı talebi',
                        'user_data_json' => json_encode($user),
                        'deleted_by_user' => 1,
                        'admin_notes' => 'Kullanıcı tarafından şifre doğrulaması ile silinmiştir'
                    ];

                    $deletedUserModel->insert($deleted_user_data);
                    log_message('info', 'Kullanıcı arşivleme başarılı - ID: ' . $user_id);
                } catch (\Exception $e) {
                    log_message('warning', 'Kullanıcı arşivlenemedi: ' . $e->getMessage());
                }
            }

            // İlişkili verileri temizle
            $this->cleanUserRelatedData($user_id);

            // Kullanıcıyı sil
            $userModel->delete($user_id);

            // Kullanıcının tüm token'larını sil
            $tokenModel->where('user_id', $user_id)->delete();

            $db->transComplete();

            if ($db->transStatus() === false) {
                throw new \Exception('Veritabanı işlemi başarısız');
            }

            log_message('info', 'Kullanıcı hesabı başarıyla silindi - ID: ' . $user_id . ', Email: ' . $user['mail'] . ', IP: ' . $current_ip);

            // Admin bildirim gönder
            $this->sendAdminNotification($user, 'Hesap Silindi');

            return $this->respond(array(
                'code'      => 'success',
                'message'   => 'Hesabınız başarıyla silindi. Verileriniz güvenli bir şekilde kaldırılmıştır.'
            ));

        } catch (\Exception $e) {
            $db->transRollback();
            
            log_message('error', 'Hesap silme hatası - Kullanıcı ID: ' . $user_id . ', Hata: ' . $e->getMessage());
            
            return $this->respond(array(
                'code'      => 'failed',
                'message'   => 'Hesap silme işlemi sırasında bir hata oluştu. Lütfen tekrar deneyin veya destek ile iletişime geçin.'
            ));
        }
    }

    /**
     * Tüm Kullanıcıları Listele (Admin only)
     */
    public function users()
    {
        if (empty($_GET['token'])) {
            return $this->respond([
                'code' => 'failed',
                'message' => 'Token missing'
            ]);
        }

        $token = $_GET['token'];
        $tokenModel = model('App\Models\TokenModel');
        $userModel = model('App\Models\UserModel');

        $user_token = $tokenModel->where('token', $token)->first();

        if (!$user_token) {
            return $this->respond([
                'code' => 'failed',
                'message' => 'Invalid token'
            ]);
        }

        $current_user = $userModel->where('id', $user_token['user_id'])->first();
        
        if (!$current_user || !in_array($current_user['type'] ?? 'USER', ['ADMIN', 'SUPER_ADMIN'])) {
            return $this->respond([
                'code' => 'failed',
                'message' => 'Insufficient permissions'
            ]);
        }

        try {
            $page = $_GET['page'] ?? 1;
            $limit = $_GET['limit'] ?? 50;
            $search = $_GET['search'] ?? '';
            $type_filter = $_GET['type_filter'] ?? '';

            $offset = ($page - 1) * $limit;

            $builder = $userModel->select('id, name_surname, mail, type, registration_date, last_login, mail_verified, phone');

            if (!empty($search)) {
                $builder->groupStart()
                       ->like('name_surname', $search)
                       ->orLike('mail', $search)
                       ->groupEnd();
            }

            if (!empty($type_filter)) {
                $builder->where('type', $type_filter);
            }

            $total = $builder->countAllResults(false);
            $users = $builder->orderBy('registration_date', 'DESC')
                           ->limit($limit, $offset)
                           ->get()
                           ->getResultArray();

            return $this->respond([
                'code' => 'success',
                'data' => $users,
                'pagination' => [
                    'current_page' => $page,
                    'per_page' => $limit,
                    'total' => $total,
                    'total_pages' => ceil($total / $limit)
                ]
            ]);

        } catch (\Exception $e) {
            log_message('error', 'Get users error: ' . $e->getMessage());
            
            return $this->respond([
                'code' => 'failed',
                'message' => 'Error retrieving users: ' . $e->getMessage()
            ]);
        }
    }

    /**
     * Kullanıcı Tipini Değiştir (Admin/SuperAdmin only)
     */
    public function change_user_type()
    {
        $data_json = $this->request->getJSON();
        
        if (empty($data_json->admin_token) || empty($data_json->user_id) || empty($data_json->new_type)) {
            return $this->respond([
                'code' => 'failed',
                'message' => 'Missing required parameters'
            ]);
        }

        $tokenModel = model('App\Models\TokenModel');
        $userModel = model('App\Models\UserModel');

        // Admin token kontrolü
        $admin_token = $tokenModel->where('token', $data_json->admin_token)->first();
        
        if (!$admin_token) {
            return $this->respond([
                'code' => 'failed',
                'message' => 'Invalid admin token'
            ]);
        }

        $admin_user = $userModel->where('id', $admin_token['user_id'])->first();
        
        if (!$admin_user || !in_array($admin_user['type'] ?? 'USER', ['ADMIN', 'SUPER_ADMIN'])) {
            return $this->respond([
                'code' => 'failed',
                'message' => 'Insufficient admin permissions'
            ]);
        }

        // Hedef kullanıcıyı bul
        $target_user = $userModel->where('id', $data_json->user_id)->first();
        
        if (!$target_user) {
            return $this->respond([
                'code' => 'failed',
                'message' => 'User not found'
            ]);
        }

        // İzin kontrolü
        $allowed_types = ['USER', 'AGENT'];
        
        if ($admin_user['type'] === 'SUPER_ADMIN') {
            $allowed_types = ['USER', 'AGENT', 'ADMIN', 'SUPER_ADMIN'];
        } elseif ($admin_user['type'] === 'ADMIN') {
            $allowed_types = ['USER', 'AGENT'];
        }

        if (!in_array($data_json->new_type, $allowed_types)) {
            return $this->respond([
                'code' => 'failed',
                'message' => 'Invalid user type or insufficient permissions'
            ]);
        }

        try {
            $old_type = $target_user['type'] ?? 'USER';
            
            $userModel->update($data_json->user_id, [
                'type' => $data_json->new_type,
                'type_changed_at' => date('Y-m-d H:i:s'),
                'type_changed_by' => $admin_user['id']
            ]);

            log_message('info', "Admin {$admin_user['id']} ({$admin_user['type']}) changed user {$data_json->user_id} type from {$old_type} to {$data_json->new_type}");

            // Bildirim gönder
            try {
                $notificationModel = model('App\Models\NotificationModel');
                
                $notification_data = [
                    'user_id' => $data_json->user_id,
                    'title' => 'Hesap Tipi Güncellendi',
                    'body' => "Hesap tipiniz {$data_json->new_type} olarak güncellendi",
                    'target' => 'account_type_changed',
                    'created_by' => $admin_user['id']
                ];
                
                $notificationModel->addNotification($notification_data);
            } catch (\Exception $e) {
                log_message('warning', 'User type change notification failed: ' . $e->getMessage());
            }

            return $this->respond([
                'code' => 'success',
                'message' => 'User type changed successfully',
                'old_type' => $old_type,
                'new_type' => $data_json->new_type
            ]);

        } catch (\Exception $e) {
            log_message('error', 'Change user type error: ' . $e->getMessage());
            
            return $this->respond([
                'code' => 'failed',
                'message' => 'Error changing user type: ' . $e->getMessage()
            ]);
        }
    }

    /**
     * Kullanıcı İstatistikleri (Admin only)
     */
    public function user_statistics()
    {
        if (empty($_GET['token'])) {
            return $this->respond([
                'code' => 'failed',
                'message' => 'Token missing'
            ]);
        }

        $token = $_GET['token'];
        $tokenModel = model('App\Models\TokenModel');
        $userModel = model('App\Models\UserModel');

        $user_token = $tokenModel->where('token', $token)->first();

        if (!$user_token) {
            return $this->respond([
                'code' => 'failed',
                'message' => 'Invalid token'
            ]);
        }

        $current_user = $userModel->where('id', $user_token['user_id'])->first();
        
        if (!$current_user || !in_array($current_user['type'] ?? 'USER', ['ADMIN', 'SUPER_ADMIN'])) {
            return $this->respond([
                'code' => 'failed',
                'message' => 'Insufficient permissions'
            ]);
        }

        try {
            $statistics = [];

            // Toplam kullanıcı sayısı
            $statistics['total_users'] = $userModel->countAllResults();

            // Tip bazında kullanıcı sayıları
            $user_types = $userModel->select('type, COUNT(*) as count')
                                   ->groupBy('type')
                                   ->get()
                                   ->getResultArray();

            $statistics['by_type'] = [];
            foreach ($user_types as $type_data) {
                $type = $type_data['type'] ?? 'USER';
                $statistics['by_type'][$type] = $type_data['count'];
            }

            // E-posta doğrulama istatistikleri
            $statistics['email_verified'] = $userModel->where('mail_verified', 1)->countAllResults();
            $statistics['email_unverified'] = $userModel->where('mail_verified', 0)->countAllResults();

            // Son 30 gündeki kayıtlar
            $statistics['last_30_days'] = $userModel->where('registration_date >=', date('Y-m-d', strtotime('-30 days')))
                                                   ->countAllResults();

            // Bugünkü kayıtlar
            $statistics['today'] = $userModel->where('DATE(registration_date)', date('Y-m-d'))
                                            ->countAllResults();

            return $this->respond([
                'code' => 'success',
                'data' => $statistics
            ]);

        } catch (\Exception $e) {
            log_message('error', 'Get user statistics error: ' . $e->getMessage());
            
            return $this->respond([
                'code' => 'failed',
                'message' => 'Error retrieving statistics: ' . $e->getMessage()
            ]);
        }
    }

    /**
     * Token Yenileme
     */
    public function refresh_token()
    {
        $data_json = $this->request->getJSON();
        
        if (empty($data_json->token) || empty($data_json->user_id)) {
            return $this->respond([
                'code' => 'failed',
                'message' => 'Token and user_id required'
            ]);
        }

        $tokenModel = model('App\Models\TokenModel');
        $userModel = model('App\Models\UserModel');

        try {
            $existing_token = $tokenModel->where('token', $data_json->token)
                                        ->where('user_id', $data_json->user_id)
                                        ->first();

            if (!$existing_token) {
                return $this->respond([
                    'code' => 'failed',
                    'message' => 'Invalid token'
                ]);
            }

            $user = $userModel->where('id', $data_json->user_id)->first();
            
            if (!$user) {
                return $this->respond([
                    'code' => 'failed',
                    'message' => 'User not found'
                ]);
            }

            $new_token = $userModel->hash_token($user['mail'] . time() . rand(1, 9999));

            $tokenModel->update($existing_token['id'], [
                'token' => $new_token,
                'date_last_access' => date('Y-m-d H:i:s')
            ]);

            return $this->respond([
                'code' => 'success',
                'token' => $new_token,
                'expire_date' => strtotime("+2 months"),
                'type' => $user['type'] ?? 'USER',
                'display_name' => $user['name_surname']
            ]);

        } catch (\Exception $e) {
            log_message('error', 'Refresh token error: ' . $e->getMessage());
            
            return $this->respond([
                'code' => 'failed',
                'message' => 'Error refreshing token: ' . $e->getMessage()
            ]);
        }
    }

    /**
     * SMTP Test
     */
    public function test_email()
    {
        $emailService = new \App\Services\EmailService();
        $result = $emailService->sendTestEmail('satisahazirapp@gmail.com');
        return $this->respond($result);
    }

    public function test_smtp_connection()
    {
        try {
            $emailService = new \App\Services\EmailService();
            $result = $emailService->testSmtpConnection();
            return $this->respond($result);
        } catch (\Exception $e) {
            return $this->respond([
                'success' => false,
                'message' => 'Test hatası: ' . $e->getMessage()
            ]);
        }
    }

    /**
     * İzinleri Getir
     */
    public function get_consents()
    {
        $userModel = model('App\Models\UserModel');
        $tokenModel = model('App\Models\TokenModel');
        
        try {
            $consentModel = model('App\Models\ConsentModel');
        } catch (\Exception $e) {
            log_message('warning', 'ConsentModel yüklenemedi: ' . $e->getMessage());
            return $this->respond([
                'code'     => 'failed',
                'message'  => 'Consent servisi kullanılamıyor'
            ]);
        }

        if (empty($_GET['token'])) {
            return $this->respond([
                'code'     => 'failed',
                'message'  => 'Token missing'
            ]);
        }

        $token = $_GET['token'];
        $user_token = $tokenModel->where('token', $token)->findAll(1);

        if (count($user_token) == 0) {
            return $this->respond([
                'code'     => 'failed',
                'message'  => 'Valid Token missing'
            ]);
        }

        $user_id = $user_token[0]['user_id'];

        if (empty($_GET['user_id'])) {
            return $this->respond([
                'code'     => 'failed',
                'message'  => 'User ID missing'
            ]);
        }

        if ($user_id != $_GET['user_id']) {
            return $this->respond([
                'code'     => 'failed',
                'message'  => 'Token missing permissions'
            ]);
        }

        try {
            $consents = $consentModel->getConsentsByUserId($user_id);

            if (count($consents) > 0) {
                $latestConsent = $consents[0];
                $consentTextVersions = [];
                
                if (!empty($latestConsent['consent_text_versions'])) {
                    $consentTextVersions = json_decode($latestConsent['consent_text_versions'], true) ?? [];
                }
                
                return $this->respond([
                    'code'              => 'success',
                    'kvkk_consent'      => $latestConsent['kvkk_consent'] ?? '0',
                    'gdpr_consent'      => $latestConsent['gdpr_consent'] ?? '0',
                    'privacy_consent'   => $latestConsent['privacy_consent'] ?? '0',
                    'marketing_consent' => $latestConsent['marketing_consent'] ?? '0',
                    'analytics_consent' => $latestConsent['analytics_consent'] ?? '0',
                    'device_info_consent' => $latestConsent['device_info_consent'] ?? '0',
                    'consent_version'   => $latestConsent['consent_version'] ?? '',
                    'consent_timestamp' => $latestConsent['created_at'] ?? '',
                    'kvkk_version'      => $consentTextVersions['kvkk_version'] ?? '',
                    'gdpr_version'      => $consentTextVersions['gdpr_version'] ?? '',
                    'privacy_version'   => $consentTextVersions['privacy_version'] ?? '',
                ]);
            } else {
                return $this->respond([
                    'code'              => 'success',
                    'kvkk_consent'      => '0',
                    'gdpr_consent'      => '0',
                    'privacy_consent'   => '0',
                    'marketing_consent' => '0',
                    'analytics_consent' => '0', 
                    'device_info_consent' => '0',
                    'consent_version'   => '',
                    'consent_timestamp' => '',
                ]);
            }
        } catch (\Exception $e) {
            log_message('error', 'Consent verisi alınırken hata: ' . $e->getMessage());
            return $this->respond([
                'code'     => 'failed',
                'message'  => 'Consent verisi alınamadı'
            ]);
        }
    }

    // YARDIMCI METODLAR

    /**
     * Kolay Doğrulama Kodu Oluştur
     */
    private function generateEasyVerificationCode()
    {
        $firstThree = sprintf('%03d', mt_rand(100, 999));
        $verificationCode = $firstThree . $firstThree;
        return $verificationCode;
    }

    /**
     * Kullanıcı İlişkili Verileri Temizle
     */
    private function cleanUserRelatedData($user_id)
    {
        $db = \Config\Database::connect();

        // İlişkili tabloları temizle - Her tablo için ayrı try-catch
        $tables_to_clean = [
            'property_user' => 'user_id',
            'reservations' => 'user_id', 
            'favorites' => 'user_id',
            'saved_search' => 'user_id',
            'affilate_packages' => 'user_id',
            'token_api' => 'user_id',
            'devices' => 'user_id',
            'notifications' => 'user_id',
            'user_consents' => 'user_id',
            'user_sessions' => 'user_id'
        ];

        foreach($tables_to_clean as $table => $user_field) {
            try {
                // Önce tablonun var olup olmadığını kontrol et
                if ($this->tableExists($table)) {
                    $builder = $db->table($table);
                    $builder->where($user_field, $user_id);
                    $deleted_count = $builder->delete();
                    
                    if ($deleted_count > 0) {
                        log_message('info', "Tablo temizlendi: $table - $deleted_count kayıt silindi");
                    }
                } else {
                    log_message('info', "Tablo mevcut değil, atlanıyor: $table");
                }
            } catch (\Exception $e) {
                log_message('warning', "Tablo temizleme hatası - Tablo: $table, Hata: " . $e->getMessage());
                continue;
            }
        }

        // Kullanıcı dosyalarını temizle
        $this->cleanUserFiles($user_id);
    }

    /**
     * Tablonun Varlığını Kontrol Et
     */
    private function tableExists($tableName)
    {
        try {
            $db = \Config\Database::connect();
            $query = $db->query("SHOW TABLES LIKE '$tableName'");
            return $query->getNumRows() > 0;
        } catch (\Exception $e) {
            log_message('warning', "Tablo varlık kontrolü hatası: $tableName - " . $e->getMessage());
            return false;
        }
    }

    /**
     * Kullanıcı Dosyalarını Temizle
     */
    private function cleanUserFiles($user_id)
    {
        try {
            $userModel = model('App\Models\UserModel');
            $user = $userModel->where('id', $user_id)->first();
            
            if($user && !empty($user['image_user_filename'])) {
                $file_path = FCPATH . 'files/' . $user['image_user_filename'];
                if(file_exists($file_path)) {
                    unlink($file_path);
                    log_message('info', 'Kullanıcı profil resmi silindi: ' . $file_path);
                }
            }
            
            // Kullanıcı klasörünü temizle (varsa)
            $user_folder = FCPATH . 'uploads/users/' . $user_id;
            if(is_dir($user_folder)) {
                $this->deleteDirectory($user_folder);
                log_message('info', 'Kullanıcı klasörü silindi: ' . $user_folder);
            }
            
        } catch (\Exception $e) {
            log_message('warning', 'Kullanıcı dosyaları temizleme hatası: ' . $e->getMessage());
        }
    }

    /**
     * Klasörü ve İçindekileri Sil
     */
    private function deleteDirectory($dir) 
    {
        if (!is_dir($dir)) {
            return false;
        }
        
        try {
            $files = array_diff(scandir($dir), array('.', '..'));
            foreach ($files as $file) {
                $path = $dir . DIRECTORY_SEPARATOR . $file;
                is_dir($path) ? $this->deleteDirectory($path) : unlink($path);
            }
            
            return rmdir($dir);
        } catch (\Exception $e) {
            log_message('warning', 'Klasör silme hatası: ' . $e->getMessage());
            return false;
        }
    }

    /**
     * Admin'e Bildirim Gönder
     */
    private function sendAdminNotification($user, $action)
    {
        try {
            $notificationModel = model('App\Models\NotificationModel');
            $userModel = model('App\Models\UserModel');
            
            // Tüm adminleri al
            $admins = $userModel->whereIn('type', ['ADMIN', 'SUPER_ADMIN'])->findAll();
            
            foreach ($admins as $admin) {
                $data_not = [
                    'user_id' => $admin['id'],
                    'title' => $action . ' - Kullanıcı İşlemi',
                    'body' => "Kullanıcı: {$user['name_surname']} ({$user['mail']}) - ID: {$user['id']} - İşlem: $action",
                    'target' => 'admin',
                    'priority' => 'high',
                    'created_at' => date('Y-m-d H:i:s')
                ];
                
                $notificationModel->addNotification($data_not);
            }
            
            log_message('info', 'Admin bildirimi gönderildi: ' . $action);
            
        } catch (\Exception $e) {
            log_message('warning', 'Admin bildirimi gönderilemedi: ' . $e->getMessage());
        }
    }

    /**
     * Silinen Kullanıcıları Listele (Admin için)
     */
    public function deleted_users_list()
    {
        // Admin yetkisi kontrolü
        if(!$this->isAdmin()) {
            return $this->respond(array(
                'code' => 'failed',
                'message' => 'Bu işlem için admin yetkisi gerekli'
            ));
        }

        try {
            $deletedUserModel = model('App\Models\DeletedUserModel');
            
            $page = $this->request->getGet('page') ?? 1;
            $limit = $this->request->getGet('limit') ?? 50;
            $offset = ($page - 1) * $limit;

            $deleted_users = $deletedUserModel->orderBy('deletion_date', 'DESC')
                                             ->findAll($limit, $offset);

            $total = $deletedUserModel->countAllResults();

            return $this->respond(array(
                'code' => 'success',
                'data' => $deleted_users,
                'pagination' => [
                    'current_page' => $page,
                    'per_page' => $limit,
                    'total' => $total,
                    'total_pages' => ceil($total / $limit)
                ]
            ));
        } catch (\Exception $e) {
            return $this->respond(array(
                'code' => 'failed',
                'message' => 'Silinen kullanıcı listesi alınamadı: ' . $e->getMessage()
            ));
        }
    }

    /**
     * Admin Yetkisi Kontrolü
     */
    private function isAdmin()
    {
        if(empty($_GET['token'])) {
            return false;
        }

        $tokenModel = model('App\Models\TokenModel');
        $userModel = model('App\Models\UserModel');
        
        $token = $_GET['token'];
        $user_token = $tokenModel->where('token', $token)->first();
        
        if(!$user_token) {
            return false;
        }

        $user = $userModel->where('id', $user_token['user_id'])->first();
        
        return $user && in_array($user['type'] ?? 'USER', ['ADMIN', 'SUPER_ADMIN']);
    }

    /**
     * İzinleri Transfer Et
     */
    public function transfer_consents()
    {
        $data_json = $this->request->getJSON();
        
        if (empty($data_json->temp_user_id) || empty($data_json->user_id) || 
            empty($data_json->token) || empty($data_json->device_uuid)) {
            return $this->respond([
                'code'     => 'failed',
                'message'  => 'Missing required parameters'
            ]);
        }
        
        $tokenModel = model('App\Models\TokenModel');
        
        $token = $data_json->token;
        $user_token = $tokenModel->where('token', $token)->findAll(1);
        
        if (count($user_token) == 0 || $user_token[0]['user_id'] != $data_json->user_id) {
            return $this->respond([
                'code'     => 'failed',
                'message'  => 'Invalid token or user ID'
            ]);
        }
        
        try {
            $consentModel = model('App\Models\ConsentModel');
            
            $deviceUuid = $data_json->device_uuid;
            $userId = $data_json->user_id;
            
            $result = $consentModel->transferConsents($deviceUuid, $userId);
            
            if ($result) {
                return $this->respond([
                    'code'     => 'success',
                    'message'  => 'Consents transferred successfully'
                ]);
            } else {
                return $this->respond([
                    'code'     => 'success',
                    'message'  => 'No consents found to transfer'
                ]);
            }
        } catch (\Exception $e) {
            log_message('error', 'Error transferring consents: ' . $e->getMessage());
            
            return $this->respond([
                'code'     => 'failed',
                'message'  => 'Error transferring consents: ' . $e->getMessage()
            ]);
        }
    }

    /**
     * Push Token Güncelle
     */
    public function update_push_token()
    {
        $data = [
            'code'     => 'empty_code',
            'message'  => 'Empty Message'
        ];

        $data_json = $this->request->getJSON();
        
        try {
            $deviceModel = model('App\Models\DeviceModel');
        } catch (\Exception $e) {
            log_message('warning', 'DeviceModel yüklenemedi: ' . $e->getMessage());
            return $this->respond([
                'code'     => 'failed',
                'message'  => 'Device servisi kullanılamıyor'
            ]);
        }

        if (empty($data_json->device_uuid)) {
            return $this->respond([
                'code'     => 'failed',
                'message'  => 'Device UUID missing'
            ]);
        }

        if (empty($data_json->push_token) && empty($data_json->fcmToken)) {
            return $this->respond([
                'code'     => 'failed',
                'message'  => 'Push token missing'
            ]);
        }

        $fcmToken = !empty($data_json->fcmToken) ? $data_json->fcmToken : $data_json->push_token;
        $deviceUuid = $data_json->device_uuid;

        $pushConsent = isset($data_json->push_consent) ? 
                      ($data_json->push_consent === true || $data_json->push_consent === '1' ? 1 : 0) : null;
        
        $marketingConsent = isset($data_json->marketing_consent) ? 
                           ($data_json->marketing_consent === true || $data_json->marketing_consent === '1' ? 1 : 0) : null;

        $additionalData = [
            'last_active' => date('Y-m-d H:i:s')
        ];

        if (!empty($data_json->user_id)) {
            $additionalData['user_id'] = $data_json->user_id;
        }

        if (!empty($data_json->user_email)) {
            $additionalData['email'] = $data_json->user_email;
        }

        if ($pushConsent !== null) {
            $additionalData['push_consent'] = $pushConsent;
        }

        if ($marketingConsent !== null) {
            $additionalData['marketing_consent'] = $marketingConsent;
        }

        try {
            $success = $deviceModel->updateFcmToken($deviceUuid, $fcmToken, $additionalData);

            if ($success) {
                $topicsToSubscribe = [];

                if (empty($data_json->user_id)) {
                    $topicsToSubscribe[] = 'anonymous';
                } else {
                    $topicsToSubscribe[] = 'user_' . $data_json->user_id;
                }

                if ($marketingConsent === 1) {
                    $topicsToSubscribe[] = 'marketing';
                } elseif ($marketingConsent === 0) {
                    $deviceModel->updateTopicSubscription($deviceUuid, 'marketing', false);
                }

                foreach ($topicsToSubscribe as $topic) {
                    $deviceModel->updateTopicSubscription($deviceUuid, $topic, true);
                }

                return $this->respond([
                    'code'     => 'success',
                    'message'  => 'Push token updated successfully'
                ]);
            } else {
                return $this->respond([
                    'code'     => 'failed',
                    'message'  => 'Error updating push token'
                ]);
            }
        } catch (\Exception $e) {
            log_message('error', 'Error updating push token: ' . $e->getMessage());
            
            return $this->respond([
                'code'     => 'failed',
                'message'  => 'Error updating push token: ' . $e->getMessage()
            ]);
        }
    }

    /**
     * Topic Aboneliklerini Güncelle
     */
    public function update_topic_subscriptions()
    {
        $data = [
            'code'     => 'empty_code',
            'message'  => 'Empty Message'
        ];

        $data_json = $this->request->getJSON();
        
        try {
            $deviceModel = model('App\Models\DeviceModel');
        } catch (\Exception $e) {
            log_message('warning', 'DeviceModel yüklenemedi: ' . $e->getMessage());
            return $this->respond([
                'code'     => 'failed',
                'message'  => 'Device servisi kullanılamıyor'
            ]);
        }

        $isAuthenticated = false;
        $userId = null;

        if (!empty($data_json->token) && !empty($data_json->user_id)) {
            $tokenModel = model('App\Models\TokenModel');
            $token = $data_json->token;
            $user_token = $tokenModel->where('token', $token)->findAll(1);

            if (count($user_token) > 0 && $user_token[0]['user_id'] == $data_json->user_id) {
                $isAuthenticated = true;
                $userId = $data_json->user_id;
            }
        }

        if (empty($data_json->device_uuid) && !$isAuthenticated) {
            return $this->respond([
                'code'     => 'failed',
                'message'  => 'Device UUID or authenticated user required'
            ]);
        }

        try {
            $topicsToAdd = !empty($data_json->subscribe_topics) ? $data_json->subscribe_topics : [];
            $topicsToRemove = !empty($data_json->unsubscribe_topics) ? $data_json->unsubscribe_topics : [];

            if (empty($topicsToAdd) && empty($topicsToRemove)) {
                return $this->respond([
                    'code'     => 'failed',
                    'message'  => 'No topics specified to add or remove'
                ]);
            }

            $success = false;

            if ($isAuthenticated && $userId) {
                $success = $deviceModel->updateUserSubscriptions($userId, $topicsToAdd, $topicsToRemove);
            } 
            else if (!empty($data_json->device_uuid)) {
                $success = true;

                foreach ($topicsToAdd as $topic) {
                    $result = $deviceModel->updateTopicSubscription($data_json->device_uuid, $topic, true);
                    if (!$result) {
                        $success = false;
                    }
                }

                foreach ($topicsToRemove as $topic) {
                    $result = $deviceModel->updateTopicSubscription($data_json->device_uuid, $topic, false);
                    if (!$result) {
                        $success = false;
                    }
                }
            }

            if ($success) {
                return $this->respond([
                    'code'     => 'success',
                    'message'  => 'Topic subscriptions updated successfully'
                ]);
            } else {
                return $this->respond([
                    'code'     => 'failed',
                    'message'  => 'Error updating topic subscriptions'
                ]);
            }
        } catch (\Exception $e) {
            log_message('error', 'Error updating topic subscriptions: ' . $e->getMessage());
            
            return $this->respond([
                'code'     => 'failed',
                'message'  => 'Error updating topic subscriptions: ' . $e->getMessage()
            ]);
        }
    }

    /**
     * Cihaz Durumunu Güncelle
     */
    public function update_device_status()
    {
        $data = [
            'code'     => 'empty_code',
            'message'  => 'Empty Message'
        ];

        $data_json = $this->request->getJSON();
        
        try {
            $deviceModel = model('App\Models\DeviceModel');
        } catch (\Exception $e) {
            log_message('warning', 'DeviceModel yüklenemedi: ' . $e->getMessage());
            return $this->respond([
                'code'     => 'failed',
                'message'  => 'Device servisi kullanılamıyor'
            ]);
        }

        $isAuthenticated = false;
        $userId = null;

        if (!empty($data_json->token) && !empty($data_json->user_id)) {
            $tokenModel = model('App\Models\TokenModel');
            $token = $data_json->token;
            $user_token = $tokenModel->where('token', $token)->findAll(1);

            if (count($user_token) > 0 && $user_token[0]['user_id'] == $data_json->user_id) {
                $isAuthenticated = true;
                $userId = $data_json->user_id;
            }
        }

        if (empty($data_json->device_uuid)) {
            return $this->respond([
                'code'     => 'failed',
                'message'  => 'Device UUID missing'
            ]);
        }

        if (!isset($data_json->is_active)) {
            return $this->respond([
                'code'     => 'failed',
                'message'  => 'Device status (is_active) missing'
            ]);
        }

        $isActive = $data_json->is_active === true || $data_json->is_active === '1' || $data_json->is_active === 1;

        try {
            if ($isAuthenticated && $userId) {
                $device = $deviceModel->where('device_uuid', $data_json->device_uuid)->first();
                if ($device && (!empty($device['user_id']) && $device['user_id'] != $userId)) {
                    return $this->respond([
                        'code'     => 'failed',
                        'message'  => 'Unauthorized device access'
                    ]);
                }
            }

            $success = $deviceModel->setDeviceActive($data_json->device_uuid, $isActive);

            if ($success) {
                return $this->respond([
                    'code'     => 'success',
                    'message'  => 'Device status updated successfully'
                ]);
            } else {
                return $this->respond([
                    'code'     => 'failed',
                    'message'  => 'Error updating device status'
                ]);
            }
        } catch (\Exception $e) {
            log_message('error', 'Error updating device status: ' . $e->getMessage());
            
            return $this->respond([
                'code'     => 'failed',
                'message'  => 'Error updating device status: ' . $e->getMessage()
            ]);
        }
    }

    /**
     * E-posta Doğrulama (GET) 
     */
    public function verify_email()
    {
        $token = $this->request->getGet('token');
        $userModel = model('App\Models\UserModel');

        if (empty($token)) {
            return view('email_verification_result', [
                'success' => false,
                'message' => 'Geçersiz doğrulama linki'
            ]);
        }

        $user = $userModel->where('verification_token', $token)->first();

        if (!$user) {
            return view('email_verification_result', [
                'success' => false,
                'message' => 'Geçersiz doğrulama linki'
            ]);
        }

        if (strtotime($user['verification_expires_at']) < time()) {
            return view('email_verification_result', [
                'success' => false,
                'message' => 'Doğrulama linki süresi dolmuş. Yeni bir link talep edin.'
            ]);
        }

        if ($user['mail_verified'] == 1) {
            return view('email_verification_result', [
                'success' => true,
                'message' => 'E-posta adresi zaten doğrulanmış',
                'already_verified' => true,
                'deep_link' => "satisahazir://email-verified?success=true&user_id=" . $user['id']
            ]);
        }

        try {
            $updateData = [
                'mail_verified' => 1,
                'verification_token' => null,
                'verification_code' => null,
                'verification_expires_at' => null,
                'email_verified_at' => date('Y-m-d H:i:s')
            ];

            $userModel->update($user['id'], $updateData);

            $deepLinkUrl = "satisahazir://email-verified?success=true&user_id=" . $user['id'];

            return view('email_verification_result', [
                'success' => true,
                'message' => 'E-posta adresiniz başarıyla doğrulandı!',
                'user_id' => $user['id'],
                'deep_link' => $deepLinkUrl,
                'user_name' => $user['name_surname']
            ]);

        } catch (\Exception $e) {
            log_message('error', 'E-posta doğrulama hatası: ' . $e->getMessage());
            
            return view('email_verification_result', [
                'success' => false,
                'message' => 'E-posta doğrulanırken hata oluştu. Lütfen tekrar deneyin.'
            ]);
        }
    }
}