<?php

namespace App\Controllers\Api\V1;

use CodeIgniter\Controller;

/**
 * Legacy Controller
 * 
 * Eski /wp-json/wdk/v1/* endpoint'lerine yapılan istekleri yakalar
 * ve 410 Gone döndürür
 */
class LegacyController extends Controller
{
    /**
     * Eski endpoint'ler için 410 Gone
     */
    public function deprecated()
    {
        // Security log
        $this->logDeprecatedAccess();

        return $this->response
            ->setStatusCode(410)
            ->setJSON([
                'code' => 'endpoint_deprecated',
                'message' => 'Bu endpoint artık kullanılmıyor. Lütfen API v1 kullanın.',
                'api_version' => 'v1',
                'base_url' => '/api/v1/',
                'migration' => [
                    'old_path' => $this->request->getPath(),
                    'documentation' => 'https://docs.satisahazir.com/api/v1/migration',
                ],
                'examples' => [
                    'login' => 'POST /api/v1/auth/login',
                    'register' => 'POST /api/v1/auth/register',
                    'listings' => 'GET /api/v1/listings',
                    'user' => 'GET /api/v1/auth/me (JWT required)',
                ],
            ]);
    }

    /**
     * Eski endpoint erişimini logla
     */
    private function logDeprecatedAccess(): void
    {
        try {
            $db = \Config\Database::connect('logs');
            $db->table('security_logs')->insert([
                'event_type' => 'deprecated_endpoint_access',
                'user_id' => null,
                'ip_address' => $this->request->getIPAddress(),
                'user_agent' => $this->request->getUserAgent()->getAgentString(),
                'data' => json_encode([
                    'path' => $this->request->getPath(),
                    'method' => $this->request->getMethod(),
                    'query' => $this->request->getGet(),
                    'referer' => $this->request->getHeaderLine('Referer'),
                ]),
                'created_at' => date('Y-m-d H:i:s'),
            ]);
        } catch (\Exception $e) {
            log_message('error', 'Legacy access log error: ' . $e->getMessage());
        }
    }
}
