<?php

namespace Config;

use CodeIgniter\Config\Filters as BaseFilters;
use CodeIgniter\Filters\Cors;
use CodeIgniter\Filters\CSRF;
use CodeIgniter\Filters\DebugToolbar;
use CodeIgniter\Filters\ForceHTTPS;
use CodeIgniter\Filters\Honeypot;
use CodeIgniter\Filters\InvalidChars;
use CodeIgniter\Filters\PageCache;
use CodeIgniter\Filters\PerformanceMetrics;
use CodeIgniter\Filters\SecureHeaders;

// Mevcut özel filtreleriniz (KORUNDU)
use App\Filters\ApiLogger;
use App\Filters\ErrorLogger;

// YENİ: JWT Security Filtreleri
use App\Filters\JWTAuthFilter;
use App\Filters\JWTAdminFilter;
use App\Filters\JWTSuperAdminFilter;
use App\Filters\JWTAgentFilter;
use App\Filters\JWTRateLimitFilter;
use App\Filters\EmailVerifiedFilter;
use App\Filters\CronAuthFilter;
use App\Filters\WebhookAuthFilter;

/**
 * ============================================================================
 * FILTERS CONFIGURATION - JWT GÜVENLİK SİSTEMİ v2.0
 * ============================================================================
 * 
 * Mevcut filtreleriniz KORUNDU + JWT filtreleri EKLENDİ
 * 
 * @version    2.0.0
 * ============================================================================
 */
class Filters extends BaseFilters
{
    /**
     * Filter Aliases
     */
    public array $aliases = [
        // =====================================================================
        // CI 4.6 Varsayılan Filtreleri (değişmedi)
        // =====================================================================
        'csrf'          => CSRF::class,
        'toolbar'       => DebugToolbar::class,
        'honeypot'      => Honeypot::class,
        'invalidchars'  => InvalidChars::class,
        'secureheaders' => SecureHeaders::class,
        'cors'          => Cors::class,
        'forcehttps'    => ForceHTTPS::class,
        'pagecache'     => PageCache::class,
        'performance'   => PerformanceMetrics::class,
        
        // =====================================================================
        // Mevcut Özel Filtreleriniz (KORUNDU)
        // =====================================================================
        'apilogger'     => ApiLogger::class,
        'errorlogger'   => ErrorLogger::class,
        
        // =====================================================================
        // YENİ: JWT Authentication Filtreleri
        // =====================================================================
        'jwt'             => JWTAuthFilter::class,        // Ana JWT doğrulama
        'jwt-admin'       => JWTAdminFilter::class,       // Admin yetkisi kontrolü
        'jwt-super-admin' => JWTSuperAdminFilter::class,  // Super Admin yetkisi
        'jwt-agent'       => JWTAgentFilter::class,       // Agent yetkisi kontrolü
        'jwt-rate-limit'  => JWTRateLimitFilter::class,   // Rate limiting
        'email-verified'  => EmailVerifiedFilter::class,  // E-posta doğrulama kontrolü
        'cron-auth'       => CronAuthFilter::class,       // Cron job IP kontrolü
        'webhook-auth'    => WebhookAuthFilter::class,    // Webhook signature kontrolü
    ];

    /**
     * CI 4.6 Required Filters (değişmedi)
     */
    public array $required = [
        'before' => [
            'forcehttps',
            'pagecache',
        ],
        'after' => [
            'pagecache',
            'performance',
            'toolbar',
        ],
    ];

    /**
     * Global Filters
     */
    public array $globals = [
        'before' => [
            'errorlogger', // Tüm istekler için hata yakalayıcı (KORUNDU)
            // 'jwt-rate-limit', // Global rate limit (opsiyonel - aktif etmek için uncomment)
        ],
        'after' => [
            'apilogger', // Mevcut API loglayıcı (KORUNDU)
        ],
    ];

    /**
     * Method-based Filters
     */
    public array $methods = [];

    /**
     * Route-based Filters
     */
    public array $filters = [
        // API v1 istekleri için loglama (YENİ path)
        'apilogger' => [
            'after' => ['api/v1/*'],
        ],
        'errorlogger' => [
            'before' => ['api/v1/*'],
        ],
        
        // Rate Limiting - API v1 için (opsiyonel)
        // Aktif etmek için aşağıdaki satırları uncomment yapın:
        // 'jwt-rate-limit' => [
        //     'before' => ['api/v1/*'],
        // ],
    ];
}
